package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaAlihealthDrugtraceTopYljgDrugtableResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.drugtable request
 * 
 * @author top auto create
 * @since 1.0, 2022.11.07
 */
public class AlibabaAlihealthDrugtraceTopYljgDrugtableRequest extends BaseTaobaoRequest<AlibabaAlihealthDrugtraceTopYljgDrugtableResponse> {
	
	

	/** 
	* 批准文号
	 */
	private String approvalLicenceNo;

	/** 
	* 结束日期
	 */
	private String endDate;

	/** 
	* 企业名称
	 */
	private String entName;

	/** 
	* 包装规格
	 */
	private String packageSpec;

	/** 
	* 页码
	 */
	private Long page;

	/** 
	* 页大小
	 */
	private Long pageSize;

	/** 
	* 药品通用名
	 */
	private String physicName;

	/** 
	* 制剂规格
	 */
	private String prepnSpec;

	/** 
	* 企业ID
	 */
	private String refEntId;

	/** 
	* 开始日期
	 */
	private String startDate;

	public void setApprovalLicenceNo(String approvalLicenceNo) {
		this.approvalLicenceNo = approvalLicenceNo;
	}

	public String getApprovalLicenceNo() {
		return this.approvalLicenceNo;
	}

	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}

	public String getEndDate() {
		return this.endDate;
	}

	public void setEntName(String entName) {
		this.entName = entName;
	}

	public String getEntName() {
		return this.entName;
	}

	public void setPackageSpec(String packageSpec) {
		this.packageSpec = packageSpec;
	}

	public String getPackageSpec() {
		return this.packageSpec;
	}

	public void setPage(Long page) {
		this.page = page;
	}

	public Long getPage() {
		return this.page;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setPhysicName(String physicName) {
		this.physicName = physicName;
	}

	public String getPhysicName() {
		return this.physicName;
	}

	public void setPrepnSpec(String prepnSpec) {
		this.prepnSpec = prepnSpec;
	}

	public String getPrepnSpec() {
		return this.prepnSpec;
	}

	public void setRefEntId(String refEntId) {
		this.refEntId = refEntId;
	}

	public String getRefEntId() {
		return this.refEntId;
	}

	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}

	public String getStartDate() {
		return this.startDate;
	}

	public String getApiMethodName() {
		return "alibaba.alihealth.drugtrace.top.yljg.drugtable";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("approval_licence_no", this.approvalLicenceNo);
		txtParams.put("end_date", this.endDate);
		txtParams.put("ent_name", this.entName);
		txtParams.put("package_spec", this.packageSpec);
		txtParams.put("page", this.page);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("physic_name", this.physicName);
		txtParams.put("prepn_spec", this.prepnSpec);
		txtParams.put("ref_ent_id", this.refEntId);
		txtParams.put("start_date", this.startDate);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAlihealthDrugtraceTopYljgDrugtableResponse> getResponseClass() {
		return AlibabaAlihealthDrugtraceTopYljgDrugtableResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(page, "page");
		RequestCheckUtils.checkNotEmpty(pageSize, "pageSize");
		RequestCheckUtils.checkNotEmpty(physicName, "physicName");
		RequestCheckUtils.checkNotEmpty(refEntId, "refEntId");
	}
	

}