package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaAlihealthDrugtraceTopYljgGetkeyflagdruginfoDownloadurlResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.getkeyflagdruginfo.downloadurl request
 * 
 * @author top auto create
 * @since 1.0, 2023.03.14
 */
public class AlibabaAlihealthDrugtraceTopYljgGetkeyflagdruginfoDownloadurlRequest extends BaseTaobaoRequest<AlibabaAlihealthDrugtraceTopYljgGetkeyflagdruginfoDownloadurlResponse> {
	
	

	/** 
	* 调用接口的企业ID
	 */
	private String refEntId;

	public void setRefEntId(String refEntId) {
		this.refEntId = refEntId;
	}

	public String getRefEntId() {
		return this.refEntId;
	}

	public String getApiMethodName() {
		return "alibaba.alihealth.drugtrace.top.yljg.getkeyflagdruginfo.downloadurl";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("ref_ent_id", this.refEntId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAlihealthDrugtraceTopYljgGetkeyflagdruginfoDownloadurlResponse> getResponseClass() {
		return AlibabaAlihealthDrugtraceTopYljgGetkeyflagdruginfoDownloadurlResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(refEntId, "refEntId");
	}
	

}