package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaAlihealthDrugtraceTopYljgListupoutDetailResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.listupout.detail request
 * 
 * @author top auto create
 * @since 1.0, 2025.05.20
 */
public class AlibabaAlihealthDrugtraceTopYljgListupoutDetailRequest extends BaseTaobaoRequest<AlibabaAlihealthDrugtraceTopYljgListupoutDetailResponse> {
	
	

	/** 
	* 单据编码
	 */
	private String billCode;

	/** 
	* 发货企业renEntId
	 */
	private String fromRefUserId;

	/** 
	* 企业id
	 */
	private String refEntId;

	/** 
	* 收货企业refEntId
	 */
	private String toRefUserId;

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillCode() {
		return this.billCode;
	}

	public void setFromRefUserId(String fromRefUserId) {
		this.fromRefUserId = fromRefUserId;
	}

	public String getFromRefUserId() {
		return this.fromRefUserId;
	}

	public void setRefEntId(String refEntId) {
		this.refEntId = refEntId;
	}

	public String getRefEntId() {
		return this.refEntId;
	}

	public void setToRefUserId(String toRefUserId) {
		this.toRefUserId = toRefUserId;
	}

	public String getToRefUserId() {
		return this.toRefUserId;
	}

	public String getApiMethodName() {
		return "alibaba.alihealth.drugtrace.top.yljg.listupout.detail";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("bill_code", this.billCode);
		txtParams.put("from_ref_user_id", this.fromRefUserId);
		txtParams.put("ref_ent_id", this.refEntId);
		txtParams.put("to_ref_user_id", this.toRefUserId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAlihealthDrugtraceTopYljgListupoutDetailResponse> getResponseClass() {
		return AlibabaAlihealthDrugtraceTopYljgListupoutDetailResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(billCode, "billCode");
		RequestCheckUtils.checkNotEmpty(fromRefUserId, "fromRefUserId");
		RequestCheckUtils.checkNotEmpty(refEntId, "refEntId");
		RequestCheckUtils.checkNotEmpty(toRefUserId, "toRefUserId");
	}
	

}