package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaAlihealthDrugtraceTopYljgQueryCodedetailResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.query.codedetail request
 * 
 * @author top auto create
 * @since 1.0, 2025.05.20
 */
public class AlibabaAlihealthDrugtraceTopYljgQueryCodedetailRequest extends BaseTaobaoRequest<AlibabaAlihealthDrugtraceTopYljgQueryCodedetailResponse> {
	
	

	/** 
	* 码列表【多个码用逗号拼接的字符串。要求数量在1000个码以下，但一般不要传这么多，如果网络不好很容易传输一半报错】
	 */
	private String codes;

	/** 
	* 企业唯一标识
	 */
	private String refEntId;

	public void setCodes(String codes) {
		this.codes = codes;
	}

	public String getCodes() {
		return this.codes;
	}

	public void setRefEntId(String refEntId) {
		this.refEntId = refEntId;
	}

	public String getRefEntId() {
		return this.refEntId;
	}

	public String getApiMethodName() {
		return "alibaba.alihealth.drugtrace.top.yljg.query.codedetail";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("codes", this.codes);
		txtParams.put("ref_ent_id", this.refEntId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAlihealthDrugtraceTopYljgQueryCodedetailResponse> getResponseClass() {
		return AlibabaAlihealthDrugtraceTopYljgQueryCodedetailResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(codes, "codes");
		RequestCheckUtils.checkMaxListSize(codes, 1000, "codes");
		RequestCheckUtils.checkNotEmpty(refEntId, "refEntId");
	}
	

}