package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaAlihealthDrugtraceTopYljgQueryListpartsResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.query.listparts request
 * 
 * @author top auto create
 * @since 1.0, 2024.11.14
 */
public class AlibabaAlihealthDrugtraceTopYljgQueryListpartsRequest extends BaseTaobaoRequest<AlibabaAlihealthDrugtraceTopYljgQueryListpartsResponse> {
	
	

	/** 
	* 开始时间
	 */
	private String beginDate;

	/** 
	* 结束时间
	 */
	private String endDate;

	/** 
	* 企业名称
	 */
	private String entName;

	/** 
	* 页码
	 */
	private Long page;

	/** 
	* 页大小
	 */
	private Long pageSize;

	/** 
	* 企业唯一标识
	 */
	private String refEntId;

	/** 
	* 企业自定义编号
	 */
	private String refPartnerId;

	public void setBeginDate(String beginDate) {
		this.beginDate = beginDate;
	}

	public String getBeginDate() {
		return this.beginDate;
	}

	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}

	public String getEndDate() {
		return this.endDate;
	}

	public void setEntName(String entName) {
		this.entName = entName;
	}

	public String getEntName() {
		return this.entName;
	}

	public void setPage(Long page) {
		this.page = page;
	}

	public Long getPage() {
		return this.page;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setRefEntId(String refEntId) {
		this.refEntId = refEntId;
	}

	public String getRefEntId() {
		return this.refEntId;
	}

	public void setRefPartnerId(String refPartnerId) {
		this.refPartnerId = refPartnerId;
	}

	public String getRefPartnerId() {
		return this.refPartnerId;
	}

	public String getApiMethodName() {
		return "alibaba.alihealth.drugtrace.top.yljg.query.listparts";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("begin_date", this.beginDate);
		txtParams.put("end_date", this.endDate);
		txtParams.put("ent_name", this.entName);
		txtParams.put("page", this.page);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("ref_ent_id", this.refEntId);
		txtParams.put("ref_partner_id", this.refPartnerId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAlihealthDrugtraceTopYljgQueryListpartsResponse> getResponseClass() {
		return AlibabaAlihealthDrugtraceTopYljgQueryListpartsResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(page, "page");
		RequestCheckUtils.checkNotEmpty(pageSize, "pageSize");
		RequestCheckUtils.checkNotEmpty(refEntId, "refEntId");
	}
	

}