package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaAlihealthDrugtraceTopYljgQueryRelationResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.query.relation request
 * 
 * @author top auto create
 * @since 1.0, 2025.03.04
 */
public class AlibabaAlihealthDrugtraceTopYljgQueryRelationRequest extends BaseTaobaoRequest<AlibabaAlihealthDrugtraceTopYljgQueryRelationResponse> {
	
	

	/** 
	* 追溯码,多个码需要逗号拼接，最大10个码
	 */
	private String code;

	/** 
	* 目标企业唯一标识（为哪个企业查询，一般与入参ref_ent_id一样）
	 */
	private String desRefEntId;

	/** 
	* 接口调用企业的唯一标识（接口调用者）
	 */
	private String refEntId;

	public void setCode(String code) {
		this.code = code;
	}

	public String getCode() {
		return this.code;
	}

	public void setDesRefEntId(String desRefEntId) {
		this.desRefEntId = desRefEntId;
	}

	public String getDesRefEntId() {
		return this.desRefEntId;
	}

	public void setRefEntId(String refEntId) {
		this.refEntId = refEntId;
	}

	public String getRefEntId() {
		return this.refEntId;
	}

	public String getApiMethodName() {
		return "alibaba.alihealth.drugtrace.top.yljg.query.relation";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("code", this.code);
		txtParams.put("des_ref_ent_id", this.desRefEntId);
		txtParams.put("ref_ent_id", this.refEntId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAlihealthDrugtraceTopYljgQueryRelationResponse> getResponseClass() {
		return AlibabaAlihealthDrugtraceTopYljgQueryRelationResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(code, "code");
		RequestCheckUtils.checkNotEmpty(desRefEntId, "desRefEntId");
		RequestCheckUtils.checkNotEmpty(refEntId, "refEntId");
	}
	

}