package com.taobao.api.request;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaAlihealthDrugtraceTopYljgQueryUpbillcodeResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.query.upbillcode request
 * 
 * @author top auto create
 * @since 1.0, 2025.03.04
 */
public class AlibabaAlihealthDrugtraceTopYljgQueryUpbillcodeRequest extends BaseTaobaoRequest<AlibabaAlihealthDrugtraceTopYljgQueryUpbillcodeResponse> {
	
	

	/** 
	* 追溯码
	 */
	private String code;

	/** 
	* 企业ID （一般为要查询单据的收货企业）
	 */
	private String refEntId;

	public void setCode(String code) {
		this.code = code;
	}

	public String getCode() {
		return this.code;
	}

	public void setRefEntId(String refEntId) {
		this.refEntId = refEntId;
	}

	public String getRefEntId() {
		return this.refEntId;
	}

	public String getApiMethodName() {
		return "alibaba.alihealth.drugtrace.top.yljg.query.upbillcode";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("code", this.code);
		txtParams.put("ref_ent_id", this.refEntId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAlihealthDrugtraceTopYljgQueryUpbillcodeResponse> getResponseClass() {
		return AlibabaAlihealthDrugtraceTopYljgQueryUpbillcodeResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}