package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaAlihealthDrugtraceTopYljgServiceGetenddateResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.service.getenddate request
 * 
 * @author top auto create
 * @since 1.0, 2023.03.14
 */
public class AlibabaAlihealthDrugtraceTopYljgServiceGetenddateRequest extends BaseTaobaoRequest<AlibabaAlihealthDrugtraceTopYljgServiceGetenddateResponse> {
	
	

	/** 
	* 药 行业线：传 1 
	 */
	private Long business;

	/** 
	* 调用接口的企业ID
	 */
	private String refEntId;

	/** 
	* 基础版：传 11
	 */
	private Long service;

	public void setBusiness(Long business) {
		this.business = business;
	}

	public Long getBusiness() {
		return this.business;
	}

	public void setRefEntId(String refEntId) {
		this.refEntId = refEntId;
	}

	public String getRefEntId() {
		return this.refEntId;
	}

	public void setService(Long service) {
		this.service = service;
	}

	public Long getService() {
		return this.service;
	}

	public String getApiMethodName() {
		return "alibaba.alihealth.drugtrace.top.yljg.service.getenddate";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("business", this.business);
		txtParams.put("ref_ent_id", this.refEntId);
		txtParams.put("service", this.service);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAlihealthDrugtraceTopYljgServiceGetenddateResponse> getResponseClass() {
		return AlibabaAlihealthDrugtraceTopYljgServiceGetenddateResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(business, "business");
		RequestCheckUtils.checkNotEmpty(refEntId, "refEntId");
		RequestCheckUtils.checkNotEmpty(service, "service");
	}
	

}