package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaAlihealthDrugtraceTopYljgUploadinoutbillResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.uploadinoutbill request
 * 
 * @author top auto create
 * @since 1.0, 2024.12.30
 */
public class AlibabaAlihealthDrugtraceTopYljgUploadinoutbillRequest extends BaseTaobaoRequest<AlibabaAlihealthDrugtraceTopYljgUploadinoutbillResponse> {
	
	

	/** 
	* 代理企业REF标识
	 */
	private String agentRefUserId;

	/** 
	* （协同平台数据合规）单据委托企业entId【疫苗药品出库单填写】
	 */
	private String assEntId;

	/** 
	* （协同平台数据合规）单据委托企业refEntId【疫苗药品出库单填写】
	 */
	private String assRefEntId;

	/** 
	* 单据编号（唯一）
	 */
	private String billCode;

	/** 
	* 单据时间（一般为药品入出库时间）
	 */
	private Date billTime;

	/** 
	* 单据类型：102代表采购入库、202代表退货出库、205代表销毁出库
	 */
	private Long billType;

	/** 
	* 已废弃，无需填写
	 */
	private String cancelReasonCode;

	/** 
	* 已废弃，无需填写
	 */
	private String cancelReasonDes;

	/** 
	* 客户端类型[必须填2]
	 */
	private String clientType;

	/** 
	* 直调企业标识
	 */
	private String destUserId;

	/** 
	* （协同平台数据合规）药品配送企业entId【添写ent_id】
	 */
	private String disEntId;

	/** 
	* （协同平台数据合规）药品配送企业【添写ref_ent_id】
	 */
	private String disRefEntId;

	/** 
	* 药品ID[企业自已系统的药品ID]
	 */
	private String drugId;

	/** 
	* （协同平台数据合规）药品列表Json[可不填写]
	 */
	private String drugListJson;

	/** 
	* 已废弃，无需填写
	 */
	private String executerCode;

	/** 
	* 已废弃，无需填写
	 */
	private String executerName;

	/** 
	* （协同平台数据合规）发货地址（可为空）
	 */
	private String fromAddress;

	/** 
	* （协同平台数据合规）发货单编号（可为空）
	 */
	private String fromBillCode;

	/** 
	* （协同平台数据合规）发货人（可为空）
	 */
	private String fromPerson;

	/** 
	* 发货企业ent_id，可通过“通过企业名得到唯一标识”接口获取；（102采购入库填药品供应商id、202退货出库填医院id、205销毁出库填医院id）
	 */
	private String fromUserId;

	/** 
	* 单据提交者(appkey编号、可为空)  
	 */
	private String operIcCode;

	/** 
	* 单据提交者姓名（可为空）
	 */
	private String operIcName;

	/** 
	* （协同平台数据合规）订货单编号（可为空）
	 */
	private String orderCode;

	/** 
	* 药品类型[2,特药，3,普药]【可以随便填写，单据上传后会以实际为准】
	 */
	private Long physicType;

	/** 
	* （协同平台数据合规）应收货总数量（可为空）
	 */
	private Long quReceivable;

	/** 
	* 上传单据的医疗机构在码上放心平台的ref_ent_id，可通过“通过企业名得到唯一标识”接口获取
	 */
	private String refUserId;

	/** 
	* 已废弃，无需填写
	 */
	private String returnReasonCode;

	/** 
	* 已废弃，无需填写
	 */
	private String returnReasonDes;

	/** 
	* 已废弃，无需填写
	 */
	private String superviserCode;

	/** 
	* 已废弃，无需填写
	 */
	private String superviserName;

	/** 
	* （协同平台数据合规）收货地址（可为空）
	 */
	private String toAddress;

	/** 
	* （协同平台数据合规）收货人（可为空）
	 */
	private String toPerson;

	/** 
	* 收货企业ent_id，可通过“通过企业名得到唯一标识”接口获取；（102采购入库填医院id、202退货出库填药品供应商id、205销毁出库填医院id）
	 */
	private String toUserId;

	/** 
	* 追溯码【多个码时用逗号拼接的字符串。要求数量在3500个码以下，但一般不要传这么多，如果网络不好很容易传输一半报错】注意：在同一张单据里，不能有重复的码；在同一张单据中不能同时上传有关联关系的大、小码
	 */
	private String traceCodes;

	/** 
	* 仓号
	 */
	private String warehouseId;

	/** 
	* （协同平台数据合规）未验证通过原因【验证未通过时填写】
	 */
	private String xtCheckCode;

	/** 
	* （协同平台数据合规）未验证通过原因描述【验证未通过时填写】
	 */
	private String xtCheckCodeDesc;

	/** 
	* （协同平台数据合规）是否验证，0：未通过验证，1：已验证
	 */
	private String xtIsCheck;

	public void setAgentRefUserId(String agentRefUserId) {
		this.agentRefUserId = agentRefUserId;
	}

	public String getAgentRefUserId() {
		return this.agentRefUserId;
	}

	public void setAssEntId(String assEntId) {
		this.assEntId = assEntId;
	}

	public String getAssEntId() {
		return this.assEntId;
	}

	public void setAssRefEntId(String assRefEntId) {
		this.assRefEntId = assRefEntId;
	}

	public String getAssRefEntId() {
		return this.assRefEntId;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillCode() {
		return this.billCode;
	}

	public void setBillTime(Date billTime) {
		this.billTime = billTime;
	}

	public Date getBillTime() {
		return this.billTime;
	}

	public void setBillType(Long billType) {
		this.billType = billType;
	}

	public Long getBillType() {
		return this.billType;
	}

	public void setCancelReasonCode(String cancelReasonCode) {
		this.cancelReasonCode = cancelReasonCode;
	}

	public String getCancelReasonCode() {
		return this.cancelReasonCode;
	}

	public void setCancelReasonDes(String cancelReasonDes) {
		this.cancelReasonDes = cancelReasonDes;
	}

	public String getCancelReasonDes() {
		return this.cancelReasonDes;
	}

	public void setClientType(String clientType) {
		this.clientType = clientType;
	}

	public String getClientType() {
		return this.clientType;
	}

	public void setDestUserId(String destUserId) {
		this.destUserId = destUserId;
	}

	public String getDestUserId() {
		return this.destUserId;
	}

	public void setDisEntId(String disEntId) {
		this.disEntId = disEntId;
	}

	public String getDisEntId() {
		return this.disEntId;
	}

	public void setDisRefEntId(String disRefEntId) {
		this.disRefEntId = disRefEntId;
	}

	public String getDisRefEntId() {
		return this.disRefEntId;
	}

	public void setDrugId(String drugId) {
		this.drugId = drugId;
	}

	public String getDrugId() {
		return this.drugId;
	}

	public void setDrugListJson(String drugListJson) {
		this.drugListJson = drugListJson;
	}

	public String getDrugListJson() {
		return this.drugListJson;
	}

	public void setExecuterCode(String executerCode) {
		this.executerCode = executerCode;
	}

	public String getExecuterCode() {
		return this.executerCode;
	}

	public void setExecuterName(String executerName) {
		this.executerName = executerName;
	}

	public String getExecuterName() {
		return this.executerName;
	}

	public void setFromAddress(String fromAddress) {
		this.fromAddress = fromAddress;
	}

	public String getFromAddress() {
		return this.fromAddress;
	}

	public void setFromBillCode(String fromBillCode) {
		this.fromBillCode = fromBillCode;
	}

	public String getFromBillCode() {
		return this.fromBillCode;
	}

	public void setFromPerson(String fromPerson) {
		this.fromPerson = fromPerson;
	}

	public String getFromPerson() {
		return this.fromPerson;
	}

	public void setFromUserId(String fromUserId) {
		this.fromUserId = fromUserId;
	}

	public String getFromUserId() {
		return this.fromUserId;
	}

	public void setOperIcCode(String operIcCode) {
		this.operIcCode = operIcCode;
	}

	public String getOperIcCode() {
		return this.operIcCode;
	}

	public void setOperIcName(String operIcName) {
		this.operIcName = operIcName;
	}

	public String getOperIcName() {
		return this.operIcName;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public String getOrderCode() {
		return this.orderCode;
	}

	public void setPhysicType(Long physicType) {
		this.physicType = physicType;
	}

	public Long getPhysicType() {
		return this.physicType;
	}

	public void setQuReceivable(Long quReceivable) {
		this.quReceivable = quReceivable;
	}

	public Long getQuReceivable() {
		return this.quReceivable;
	}

	public void setRefUserId(String refUserId) {
		this.refUserId = refUserId;
	}

	public String getRefUserId() {
		return this.refUserId;
	}

	public void setReturnReasonCode(String returnReasonCode) {
		this.returnReasonCode = returnReasonCode;
	}

	public String getReturnReasonCode() {
		return this.returnReasonCode;
	}

	public void setReturnReasonDes(String returnReasonDes) {
		this.returnReasonDes = returnReasonDes;
	}

	public String getReturnReasonDes() {
		return this.returnReasonDes;
	}

	public void setSuperviserCode(String superviserCode) {
		this.superviserCode = superviserCode;
	}

	public String getSuperviserCode() {
		return this.superviserCode;
	}

	public void setSuperviserName(String superviserName) {
		this.superviserName = superviserName;
	}

	public String getSuperviserName() {
		return this.superviserName;
	}

	public void setToAddress(String toAddress) {
		this.toAddress = toAddress;
	}

	public String getToAddress() {
		return this.toAddress;
	}

	public void setToPerson(String toPerson) {
		this.toPerson = toPerson;
	}

	public String getToPerson() {
		return this.toPerson;
	}

	public void setToUserId(String toUserId) {
		this.toUserId = toUserId;
	}

	public String getToUserId() {
		return this.toUserId;
	}

	public void setTraceCodes(String traceCodes) {
		this.traceCodes = traceCodes;
	}

	public String getTraceCodes() {
		return this.traceCodes;
	}

	public void setWarehouseId(String warehouseId) {
		this.warehouseId = warehouseId;
	}

	public String getWarehouseId() {
		return this.warehouseId;
	}

	public void setXtCheckCode(String xtCheckCode) {
		this.xtCheckCode = xtCheckCode;
	}

	public String getXtCheckCode() {
		return this.xtCheckCode;
	}

	public void setXtCheckCodeDesc(String xtCheckCodeDesc) {
		this.xtCheckCodeDesc = xtCheckCodeDesc;
	}

	public String getXtCheckCodeDesc() {
		return this.xtCheckCodeDesc;
	}

	public void setXtIsCheck(String xtIsCheck) {
		this.xtIsCheck = xtIsCheck;
	}

	public String getXtIsCheck() {
		return this.xtIsCheck;
	}

	public String getApiMethodName() {
		return "alibaba.alihealth.drugtrace.top.yljg.uploadinoutbill";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("agent_ref_user_id", this.agentRefUserId);
		txtParams.put("ass_ent_id", this.assEntId);
		txtParams.put("ass_ref_ent_id", this.assRefEntId);
		txtParams.put("bill_code", this.billCode);
		txtParams.put("bill_time", this.billTime);
		txtParams.put("bill_type", this.billType);
		txtParams.put("cancel_reason_code", this.cancelReasonCode);
		txtParams.put("cancel_reason_des", this.cancelReasonDes);
		txtParams.put("client_type", this.clientType);
		txtParams.put("dest_user_id", this.destUserId);
		txtParams.put("dis_ent_id", this.disEntId);
		txtParams.put("dis_ref_ent_id", this.disRefEntId);
		txtParams.put("drug_id", this.drugId);
		txtParams.put("drug_list_json", this.drugListJson);
		txtParams.put("executer_code", this.executerCode);
		txtParams.put("executer_name", this.executerName);
		txtParams.put("from_address", this.fromAddress);
		txtParams.put("from_bill_code", this.fromBillCode);
		txtParams.put("from_person", this.fromPerson);
		txtParams.put("from_user_id", this.fromUserId);
		txtParams.put("oper_ic_code", this.operIcCode);
		txtParams.put("oper_ic_name", this.operIcName);
		txtParams.put("order_code", this.orderCode);
		txtParams.put("physic_type", this.physicType);
		txtParams.put("qu_receivable", this.quReceivable);
		txtParams.put("ref_user_id", this.refUserId);
		txtParams.put("return_reason_code", this.returnReasonCode);
		txtParams.put("return_reason_des", this.returnReasonDes);
		txtParams.put("superviser_code", this.superviserCode);
		txtParams.put("superviser_name", this.superviserName);
		txtParams.put("to_address", this.toAddress);
		txtParams.put("to_person", this.toPerson);
		txtParams.put("to_user_id", this.toUserId);
		txtParams.put("trace_codes", this.traceCodes);
		txtParams.put("warehouse_id", this.warehouseId);
		txtParams.put("xt_check_code", this.xtCheckCode);
		txtParams.put("xt_check_code_desc", this.xtCheckCodeDesc);
		txtParams.put("xt_is_check", this.xtIsCheck);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAlihealthDrugtraceTopYljgUploadinoutbillResponse> getResponseClass() {
		return AlibabaAlihealthDrugtraceTopYljgUploadinoutbillResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(billCode, "billCode");
		RequestCheckUtils.checkNotEmpty(billTime, "billTime");
		RequestCheckUtils.checkNotEmpty(billType, "billType");
		RequestCheckUtils.checkNotEmpty(clientType, "clientType");
		RequestCheckUtils.checkNotEmpty(fromUserId, "fromUserId");
		RequestCheckUtils.checkNotEmpty(physicType, "physicType");
		RequestCheckUtils.checkNotEmpty(refUserId, "refUserId");
		RequestCheckUtils.checkNotEmpty(toUserId, "toUserId");
		RequestCheckUtils.checkNotEmpty(traceCodes, "traceCodes");
		RequestCheckUtils.checkMaxListSize(traceCodes, 3500, "traceCodes");
	}
	

}