package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.drugtable response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaAlihealthDrugtraceTopYljgDrugtableResponse extends TaobaoResponse {

	private static final long serialVersionUID = 7459224819363426796L;

	/** 
	 * 监控宝推送网站监控信息，返回结果
	 */
	@ApiField("result")
	private ResultModel result;


	public void setResult(ResultModel result) {
		this.result = result;
	}
	public ResultModel getResult( ) {
		return this.result;
	}
	
	/**
 * 码列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CodeResList extends TaobaoObject {

	private static final long serialVersionUID = 5832335726126149424L;

	/**
		 * 层级
		 */
		@ApiField("code_level")
		private String codeLevel;
		/**
		 * 码前缀
		 */
		@ApiField("code_prefix")
		private String codePrefix;
		/**
		 * 包装比例
		 */
		@ApiField("pkg_ratio")
		private String pkgRatio;
		/**
		 * 资源码
		 */
		@ApiField("res_code")
		private String resCode;
	

	public String getCodeLevel() {
			return this.codeLevel;
		}
		public void setCodeLevel(String codeLevel) {
			this.codeLevel = codeLevel;
		}
		public String getCodePrefix() {
			return this.codePrefix;
		}
		public void setCodePrefix(String codePrefix) {
			this.codePrefix = codePrefix;
		}
		public String getPkgRatio() {
			return this.pkgRatio;
		}
		public void setPkgRatio(String pkgRatio) {
			this.pkgRatio = pkgRatio;
		}
		public String getResCode() {
			return this.resCode;
		}
		public void setResCode(String resCode) {
			this.resCode = resCode;
		}

}

	/**
 * 子列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SubTypeList extends TaobaoObject {

	private static final long serialVersionUID = 1129887498826614856L;

	/**
		 * 批准文号
		 */
		@ApiField("approve_no")
		private String approveNo;
		/**
		 * 码列表
		 */
		@ApiListField("code_res_list")
		@ApiField("code_res_list")
		private List<CodeResList> codeResList;
		/**
		 * 药品ID
		 */
		@ApiField("drug_ent_base_info_id")
		private String drugEntBaseInfoId;
		/**
		 * 包装单位
		 */
		@ApiField("pack_unit")
		private String packUnit;
		/**
		 * 包装单位
		 */
		@ApiField("pack_unit_name")
		private String packUnitName;
		/**
		 * 包装规格
		 */
		@ApiField("package_spec")
		private String packageSpec;
		/**
		 * 药品详情类型
		 */
		@ApiField("physic_detail_type")
		private String physicDetailType;
		/**
		 * 制剂描述
		 */
		@ApiField("prepn_desc")
		private String prepnDesc;
		/**
		 * 制剂规格
		 */
		@ApiField("prepn_spec")
		private String prepnSpec;
		/**
		 * 制剂单位
		 */
		@ApiField("prepn_unit")
		private String prepnUnit;
		/**
		 * 制剂单位描述
		 */
		@ApiField("prepn_unit_name")
		private String prepnUnitName;
		/**
		 * 企业药品ID
		 */
		@ApiField("prod_seq_no")
		private String prodSeqNo;
		/**
		 * 子类型
		 */
		@ApiField("sub_type_no")
		private String subTypeNo;
	

	public String getApproveNo() {
			return this.approveNo;
		}
		public void setApproveNo(String approveNo) {
			this.approveNo = approveNo;
		}
		public List<CodeResList> getCodeResList() {
			return this.codeResList;
		}
		public void setCodeResList(List<CodeResList> codeResList) {
			this.codeResList = codeResList;
		}
		public String getDrugEntBaseInfoId() {
			return this.drugEntBaseInfoId;
		}
		public void setDrugEntBaseInfoId(String drugEntBaseInfoId) {
			this.drugEntBaseInfoId = drugEntBaseInfoId;
		}
		public String getPackUnit() {
			return this.packUnit;
		}
		public void setPackUnit(String packUnit) {
			this.packUnit = packUnit;
		}
		public String getPackUnitName() {
			return this.packUnitName;
		}
		public void setPackUnitName(String packUnitName) {
			this.packUnitName = packUnitName;
		}
		public String getPackageSpec() {
			return this.packageSpec;
		}
		public void setPackageSpec(String packageSpec) {
			this.packageSpec = packageSpec;
		}
		public String getPhysicDetailType() {
			return this.physicDetailType;
		}
		public void setPhysicDetailType(String physicDetailType) {
			this.physicDetailType = physicDetailType;
		}
		public String getPrepnDesc() {
			return this.prepnDesc;
		}
		public void setPrepnDesc(String prepnDesc) {
			this.prepnDesc = prepnDesc;
		}
		public String getPrepnSpec() {
			return this.prepnSpec;
		}
		public void setPrepnSpec(String prepnSpec) {
			this.prepnSpec = prepnSpec;
		}
		public String getPrepnUnit() {
			return this.prepnUnit;
		}
		public void setPrepnUnit(String prepnUnit) {
			this.prepnUnit = prepnUnit;
		}
		public String getPrepnUnitName() {
			return this.prepnUnitName;
		}
		public void setPrepnUnitName(String prepnUnitName) {
			this.prepnUnitName = prepnUnitName;
		}
		public String getProdSeqNo() {
			return this.prodSeqNo;
		}
		public void setProdSeqNo(String prodSeqNo) {
			this.prodSeqNo = prodSeqNo;
		}
		public String getSubTypeNo() {
			return this.subTypeNo;
		}
		public void setSubTypeNo(String subTypeNo) {
			this.subTypeNo = subTypeNo;
		}

}

	/**
 * 返回列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class DrugTableDto extends TaobaoObject {

	private static final long serialVersionUID = 2296759113126621647L;

	/**
		 * 企业名称
		 */
		@ApiField("ent_name")
		private String entName;
		/**
		 * 修改日期
		 */
		@ApiField("mod_date")
		private String modDate;
		/**
		 * 药品详细类型
		 */
		@ApiField("physic_detail_type")
		private Long physicDetailType;
		/**
		 * 药品类型详情描述
		 */
		@ApiField("physic_detail_type_desc")
		private String physicDetailTypeDesc;
		/**
		 * 药品名称
		 */
		@ApiField("physic_name")
		private String physicName;
		/**
		 * 药品类型(详见码表) 1：特殊药品原料药，2：特殊药品制剂，3：普通药品，9：未分类
		 */
		@ApiField("physic_type")
		private Long physicType;
		/**
		 * 药品类型描述
		 */
		@ApiField("physic_type_desc")
		private String physicTypeDesc;
		/**
		 * 包装单位描述
		 */
		@ApiField("pkg_unit_desc")
		private String pkgUnitDesc;
		/**
		 * 制剂类型描述
		 */
		@ApiField("prepn_type_desc")
		private String prepnTypeDesc;
		/**
		 * 制剂单位描述
		 */
		@ApiField("prepn_unit_desc")
		private String prepnUnitDesc;
		/**
		 * 药品自类编码
		 */
		@ApiField("prod_code")
		private String prodCode;
		/**
		 * 商品名称
		 */
		@ApiField("prod_name")
		private String prodName;
		/**
		 * 企业主键
		 */
		@ApiField("ref_ent_id")
		private String refEntId;
		/**
		 * 子列表
		 */
		@ApiListField("sub_type_list")
		@ApiField("sub_type_list")
		private List<SubTypeList> subTypeList;
	

	public String getEntName() {
			return this.entName;
		}
		public void setEntName(String entName) {
			this.entName = entName;
		}
		public String getModDate() {
			return this.modDate;
		}
		public void setModDate(String modDate) {
			this.modDate = modDate;
		}
		public Long getPhysicDetailType() {
			return this.physicDetailType;
		}
		public void setPhysicDetailType(Long physicDetailType) {
			this.physicDetailType = physicDetailType;
		}
		public String getPhysicDetailTypeDesc() {
			return this.physicDetailTypeDesc;
		}
		public void setPhysicDetailTypeDesc(String physicDetailTypeDesc) {
			this.physicDetailTypeDesc = physicDetailTypeDesc;
		}
		public String getPhysicName() {
			return this.physicName;
		}
		public void setPhysicName(String physicName) {
			this.physicName = physicName;
		}
		public Long getPhysicType() {
			return this.physicType;
		}
		public void setPhysicType(Long physicType) {
			this.physicType = physicType;
		}
		public String getPhysicTypeDesc() {
			return this.physicTypeDesc;
		}
		public void setPhysicTypeDesc(String physicTypeDesc) {
			this.physicTypeDesc = physicTypeDesc;
		}
		public String getPkgUnitDesc() {
			return this.pkgUnitDesc;
		}
		public void setPkgUnitDesc(String pkgUnitDesc) {
			this.pkgUnitDesc = pkgUnitDesc;
		}
		public String getPrepnTypeDesc() {
			return this.prepnTypeDesc;
		}
		public void setPrepnTypeDesc(String prepnTypeDesc) {
			this.prepnTypeDesc = prepnTypeDesc;
		}
		public String getPrepnUnitDesc() {
			return this.prepnUnitDesc;
		}
		public void setPrepnUnitDesc(String prepnUnitDesc) {
			this.prepnUnitDesc = prepnUnitDesc;
		}
		public String getProdCode() {
			return this.prodCode;
		}
		public void setProdCode(String prodCode) {
			this.prodCode = prodCode;
		}
		public String getProdName() {
			return this.prodName;
		}
		public void setProdName(String prodName) {
			this.prodName = prodName;
		}
		public String getRefEntId() {
			return this.refEntId;
		}
		public void setRefEntId(String refEntId) {
			this.refEntId = refEntId;
		}
		public List<SubTypeList> getSubTypeList() {
			return this.subTypeList;
		}
		public void setSubTypeList(List<SubTypeList> subTypeList) {
			this.subTypeList = subTypeList;
		}

}

	/**
 * 返回模型
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Page extends TaobaoObject {

	private static final long serialVersionUID = 7285334581371867515L;

	/**
		 * 当前页
		 */
		@ApiField("page")
		private Long page;
		/**
		 * 分页大小
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 返回列表
		 */
		@ApiListField("result_list")
		@ApiField("drug_table_dto")
		private List<DrugTableDto> resultList;
		/**
		 * 总计
		 */
		@ApiField("total_num")
		private Long totalNum;
	

	public Long getPage() {
			return this.page;
		}
		public void setPage(Long page) {
			this.page = page;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public List<DrugTableDto> getResultList() {
			return this.resultList;
		}
		public void setResultList(List<DrugTableDto> resultList) {
			this.resultList = resultList;
		}
		public Long getTotalNum() {
			return this.totalNum;
		}
		public void setTotalNum(Long totalNum) {
			this.totalNum = totalNum;
		}

}

	/**
 * 监控宝推送网站监控信息，返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ResultModel extends TaobaoObject {

	private static final long serialVersionUID = 2868211281786949213L;

	/**
		 * 返回模型
		 */
		@ApiField("model")
		private Page model;
		/**
		 * 状态码
		 */
		@ApiField("msg_code")
		private String msgCode;
		/**
		 * 状态值
		 */
		@ApiField("msg_info")
		private String msgInfo;
		/**
		 * 是否响应成功
		 */
		@ApiField("response_success")
		private Boolean responseSuccess;
	

	public Page getModel() {
			return this.model;
		}
		public void setModel(Page model) {
			this.model = model;
		}
		public String getMsgCode() {
			return this.msgCode;
		}
		public void setMsgCode(String msgCode) {
			this.msgCode = msgCode;
		}
		public String getMsgInfo() {
			return this.msgInfo;
		}
		public void setMsgInfo(String msgInfo) {
			this.msgInfo = msgInfo;
		}
		public Boolean getResponseSuccess() {
			return this.responseSuccess;
		}
		public void setResponseSuccess(Boolean responseSuccess) {
			this.responseSuccess = responseSuccess;
		}

}



}
