package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.getdruglist response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaAlihealthDrugtraceTopYljgGetdruglistResponse extends TaobaoResponse {

	private static final long serialVersionUID = 5134159143659779594L;

	/** 
	 * 返回结果
	 */
	@ApiField("result")
	private ResultModel result;


	public void setResult(ResultModel result) {
		this.result = result;
	}
	public ResultModel getResult( ) {
		return this.result;
	}
	
	/**
 * 结果列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class DrugDetailInfoDto extends TaobaoObject {

	private static final long serialVersionUID = 4756215928426429644L;

	/**
		 * 批准文号
		 */
		@ApiField("approve_no")
		private String approveNo;
		/**
		 * 药品id
		 */
		@ApiField("drug_ent_base_info_id")
		private String drugEntBaseInfoId;
		/**
		 * 修改日期
		 */
		@ApiField("mod_date")
		private String modDate;
		/**
		 * 药品详细类型
		 */
		@ApiField("physic_detail_type")
		private String physicDetailType;
		/**
		 * 药品信息
		 */
		@ApiField("physic_info")
		private String physicInfo;
		/**
		 * 药品通用名称
		 */
		@ApiField("physic_name")
		private String physicName;
		/**
		 * 药品类型(详见码表) 1：特殊药品原料药，2：特殊药品制剂，3：普通药品，9：未分类
		 */
		@ApiField("physic_type")
		private String physicType;
		/**
		 * 包装规格
		 */
		@ApiField("pkg_spec")
		private String pkgSpec;
		/**
		 * 包装单位
		 */
		@ApiField("pkg_unit")
		private String pkgUnit;
		/**
		 * 包装单位描述
		 */
		@ApiField("pkg_unit_desc")
		private String pkgUnitDesc;
		/**
		 * 制剂规格
		 */
		@ApiField("prepn_spec")
		private String prepnSpec;
		/**
		 * 制剂单位类型(详见码表)  赋码最小包装内使用单元单位
		 */
		@ApiField("prepn_unit")
		private String prepnUnit;
		/**
		 * 制剂单位描述
		 */
		@ApiField("prepn_unit_desc")
		private String prepnUnitDesc;
		/**
		 * 药品子类编码
		 */
		@ApiField("prod_code")
		private String prodCode;
		/**
		 * 商品名称
		 */
		@ApiField("prod_name")
		private String prodName;
		/**
		 * 生产厂企业名称
		 */
		@ApiField("produce_ent_name")
		private String produceEntName;
		/**
		 * 企业id
		 */
		@ApiField("produce_ref_ent_id")
		private String produceRefEntId;
	

	public String getApproveNo() {
			return this.approveNo;
		}
		public void setApproveNo(String approveNo) {
			this.approveNo = approveNo;
		}
		public String getDrugEntBaseInfoId() {
			return this.drugEntBaseInfoId;
		}
		public void setDrugEntBaseInfoId(String drugEntBaseInfoId) {
			this.drugEntBaseInfoId = drugEntBaseInfoId;
		}
		public String getModDate() {
			return this.modDate;
		}
		public void setModDate(String modDate) {
			this.modDate = modDate;
		}
		public String getPhysicDetailType() {
			return this.physicDetailType;
		}
		public void setPhysicDetailType(String physicDetailType) {
			this.physicDetailType = physicDetailType;
		}
		public String getPhysicInfo() {
			return this.physicInfo;
		}
		public void setPhysicInfo(String physicInfo) {
			this.physicInfo = physicInfo;
		}
		public String getPhysicName() {
			return this.physicName;
		}
		public void setPhysicName(String physicName) {
			this.physicName = physicName;
		}
		public String getPhysicType() {
			return this.physicType;
		}
		public void setPhysicType(String physicType) {
			this.physicType = physicType;
		}
		public String getPkgSpec() {
			return this.pkgSpec;
		}
		public void setPkgSpec(String pkgSpec) {
			this.pkgSpec = pkgSpec;
		}
		public String getPkgUnit() {
			return this.pkgUnit;
		}
		public void setPkgUnit(String pkgUnit) {
			this.pkgUnit = pkgUnit;
		}
		public String getPkgUnitDesc() {
			return this.pkgUnitDesc;
		}
		public void setPkgUnitDesc(String pkgUnitDesc) {
			this.pkgUnitDesc = pkgUnitDesc;
		}
		public String getPrepnSpec() {
			return this.prepnSpec;
		}
		public void setPrepnSpec(String prepnSpec) {
			this.prepnSpec = prepnSpec;
		}
		public String getPrepnUnit() {
			return this.prepnUnit;
		}
		public void setPrepnUnit(String prepnUnit) {
			this.prepnUnit = prepnUnit;
		}
		public String getPrepnUnitDesc() {
			return this.prepnUnitDesc;
		}
		public void setPrepnUnitDesc(String prepnUnitDesc) {
			this.prepnUnitDesc = prepnUnitDesc;
		}
		public String getProdCode() {
			return this.prodCode;
		}
		public void setProdCode(String prodCode) {
			this.prodCode = prodCode;
		}
		public String getProdName() {
			return this.prodName;
		}
		public void setProdName(String prodName) {
			this.prodName = prodName;
		}
		public String getProduceEntName() {
			return this.produceEntName;
		}
		public void setProduceEntName(String produceEntName) {
			this.produceEntName = produceEntName;
		}
		public String getProduceRefEntId() {
			return this.produceRefEntId;
		}
		public void setProduceRefEntId(String produceRefEntId) {
			this.produceRefEntId = produceRefEntId;
		}

}

	/**
 * 返回模型
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Page extends TaobaoObject {

	private static final long serialVersionUID = 4532361262469155749L;

	/**
		 * 当前页
		 */
		@ApiField("page")
		private Long page;
		/**
		 * 页大小
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 结果列表
		 */
		@ApiListField("result_list")
		@ApiField("drug_detail_info_dto")
		private List<DrugDetailInfoDto> resultList;
		/**
		 * 总计
		 */
		@ApiField("total_num")
		private Long totalNum;
	

	public Long getPage() {
			return this.page;
		}
		public void setPage(Long page) {
			this.page = page;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public List<DrugDetailInfoDto> getResultList() {
			return this.resultList;
		}
		public void setResultList(List<DrugDetailInfoDto> resultList) {
			this.resultList = resultList;
		}
		public Long getTotalNum() {
			return this.totalNum;
		}
		public void setTotalNum(Long totalNum) {
			this.totalNum = totalNum;
		}

}

	/**
 * 返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ResultModel extends TaobaoObject {

	private static final long serialVersionUID = 6243852878945495322L;

	/**
		 * 返回模型
		 */
		@ApiField("model")
		private Page model;
		/**
		 * 状态码
		 */
		@ApiField("msg_code")
		private String msgCode;
		/**
		 * 状态值
		 */
		@ApiField("msg_info")
		private String msgInfo;
		/**
		 * 是否响应成功
		 */
		@ApiField("response_success")
		private String responseSuccess;
	

	public Page getModel() {
			return this.model;
		}
		public void setModel(Page model) {
			this.model = model;
		}
		public String getMsgCode() {
			return this.msgCode;
		}
		public void setMsgCode(String msgCode) {
			this.msgCode = msgCode;
		}
		public String getMsgInfo() {
			return this.msgInfo;
		}
		public void setMsgInfo(String msgInfo) {
			this.msgInfo = msgInfo;
		}
		public String getResponseSuccess() {
			return this.responseSuccess;
		}
		public void setResponseSuccess(String responseSuccess) {
			this.responseSuccess = responseSuccess;
		}

}



}
