package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.listupout.detail response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaAlihealthDrugtraceTopYljgListupoutDetailResponse extends TaobaoResponse {

	private static final long serialVersionUID = 7723681122947563765L;

	/** 
	 * 监控宝推送网站监控信息，返回结果
	 */
	@ApiField("result")
	private ResultModel result;


	public void setResult(ResultModel result) {
		this.result = result;
	}
	public ResultModel getResult( ) {
		return this.result;
	}
	
	/**
 * 码信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CodeInfoListDto extends TaobaoObject {

	private static final long serialVersionUID = 7791278884818988575L;

	/**
		 * 监管码
		 */
		@ApiField("code")
		private String code;
		/**
		 * 监管码级别
		 */
		@ApiField("code_level")
		private String codeLevel;
		/**
		 * 最小包装数量
		 */
		@ApiField("pkg_amount")
		private String pkgAmount;
		/**
		 * 最小制剂数量
		 */
		@ApiField("prepn_amount")
		private String prepnAmount;
		/**
		 * 制剂规格
		 */
		@ApiField("prepn_spec")
		private String prepnSpec;
	

	public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public String getCodeLevel() {
			return this.codeLevel;
		}
		public void setCodeLevel(String codeLevel) {
			this.codeLevel = codeLevel;
		}
		public String getPkgAmount() {
			return this.pkgAmount;
		}
		public void setPkgAmount(String pkgAmount) {
			this.pkgAmount = pkgAmount;
		}
		public String getPrepnAmount() {
			return this.prepnAmount;
		}
		public void setPrepnAmount(String prepnAmount) {
			this.prepnAmount = prepnAmount;
		}
		public String getPrepnSpec() {
			return this.prepnSpec;
		}
		public void setPrepnSpec(String prepnSpec) {
			this.prepnSpec = prepnSpec;
		}

}

	/**
 * 药品信息数据
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class DrugInfosDto extends TaobaoObject {

	private static final long serialVersionUID = 6211381819171211736L;

	/**
		 * 批准文号
		 */
		@ApiField("approval_no")
		private String approvalNo;
		/**
		 * 码信息
		 */
		@ApiListField("code_info_list_dto_list")
		@ApiField("code_info_list_dto")
		private List<CodeInfoListDto> codeInfoListDtoList;
		/**
		 * 药品标识
		 */
		@ApiField("drug_ent_base_info_id")
		private String drugEntBaseInfoId;
		/**
		 * 按最小包装单位统计数量
		 */
		@ApiField("least_pkg_amount")
		private String leastPkgAmount;
		/**
		 * 按最小制剂单位统计数量
		 */
		@ApiField("least_prepn_amount")
		private String leastPrepnAmount;
		/**
		 * 产品包装规格
		 */
		@ApiField("package_spec")
		private String packageSpec;
		/**
		 * 药品通用名
		 */
		@ApiField("physic_name")
		private String physicName;
		/**
		 * 药品类型
		 */
		@ApiField("physic_type")
		private String physicType;
		/**
		 * 药品类型描述
		 */
		@ApiField("physic_type_name")
		private String physicTypeName;
		/**
		 * 包装单位描述
		 */
		@ApiField("pkg_unit_desc")
		private String pkgUnitDesc;
		/**
		 * 制剂单位
		 */
		@ApiField("preparations_unit")
		private String preparationsUnit;
		/**
		 * 制剂规格
		 */
		@ApiField("prepn_spec")
		private String prepnSpec;
		/**
		 * 制剂规格描述
		 */
		@ApiField("prepn_type_desc")
		private String prepnTypeDesc;
		/**
		 * 制剂单位编码
		 */
		@ApiField("prepn_unit")
		private String prepnUnit;
		/**
		 * 药品商品名
		 */
		@ApiField("prod_name")
		private String prodName;
		/**
		 * 药品标识
		 */
		@ApiField("prod_seq_no")
		private String prodSeqNo;
		/**
		 * 批次号
		 */
		@ApiField("produce_batch_no")
		private String produceBatchNo;
		/**
		 * 生产日期
		 */
		@ApiField("produce_date")
		private String produceDate;
		/**
		 * 生产企业名称
		 */
		@ApiField("product_ent_name")
		private String productEntName;
		/**
		 * 有效期至
		 */
		@ApiField("valid_end_date")
		private String validEndDate;
	

	public String getApprovalNo() {
			return this.approvalNo;
		}
		public void setApprovalNo(String approvalNo) {
			this.approvalNo = approvalNo;
		}
		public List<CodeInfoListDto> getCodeInfoListDtoList() {
			return this.codeInfoListDtoList;
		}
		public void setCodeInfoListDtoList(List<CodeInfoListDto> codeInfoListDtoList) {
			this.codeInfoListDtoList = codeInfoListDtoList;
		}
		public String getDrugEntBaseInfoId() {
			return this.drugEntBaseInfoId;
		}
		public void setDrugEntBaseInfoId(String drugEntBaseInfoId) {
			this.drugEntBaseInfoId = drugEntBaseInfoId;
		}
		public String getLeastPkgAmount() {
			return this.leastPkgAmount;
		}
		public void setLeastPkgAmount(String leastPkgAmount) {
			this.leastPkgAmount = leastPkgAmount;
		}
		public String getLeastPrepnAmount() {
			return this.leastPrepnAmount;
		}
		public void setLeastPrepnAmount(String leastPrepnAmount) {
			this.leastPrepnAmount = leastPrepnAmount;
		}
		public String getPackageSpec() {
			return this.packageSpec;
		}
		public void setPackageSpec(String packageSpec) {
			this.packageSpec = packageSpec;
		}
		public String getPhysicName() {
			return this.physicName;
		}
		public void setPhysicName(String physicName) {
			this.physicName = physicName;
		}
		public String getPhysicType() {
			return this.physicType;
		}
		public void setPhysicType(String physicType) {
			this.physicType = physicType;
		}
		public String getPhysicTypeName() {
			return this.physicTypeName;
		}
		public void setPhysicTypeName(String physicTypeName) {
			this.physicTypeName = physicTypeName;
		}
		public String getPkgUnitDesc() {
			return this.pkgUnitDesc;
		}
		public void setPkgUnitDesc(String pkgUnitDesc) {
			this.pkgUnitDesc = pkgUnitDesc;
		}
		public String getPreparationsUnit() {
			return this.preparationsUnit;
		}
		public void setPreparationsUnit(String preparationsUnit) {
			this.preparationsUnit = preparationsUnit;
		}
		public String getPrepnSpec() {
			return this.prepnSpec;
		}
		public void setPrepnSpec(String prepnSpec) {
			this.prepnSpec = prepnSpec;
		}
		public String getPrepnTypeDesc() {
			return this.prepnTypeDesc;
		}
		public void setPrepnTypeDesc(String prepnTypeDesc) {
			this.prepnTypeDesc = prepnTypeDesc;
		}
		public String getPrepnUnit() {
			return this.prepnUnit;
		}
		public void setPrepnUnit(String prepnUnit) {
			this.prepnUnit = prepnUnit;
		}
		public String getProdName() {
			return this.prodName;
		}
		public void setProdName(String prodName) {
			this.prodName = prodName;
		}
		public String getProdSeqNo() {
			return this.prodSeqNo;
		}
		public void setProdSeqNo(String prodSeqNo) {
			this.prodSeqNo = prodSeqNo;
		}
		public String getProduceBatchNo() {
			return this.produceBatchNo;
		}
		public void setProduceBatchNo(String produceBatchNo) {
			this.produceBatchNo = produceBatchNo;
		}
		public String getProduceDate() {
			return this.produceDate;
		}
		public void setProduceDate(String produceDate) {
			this.produceDate = produceDate;
		}
		public String getProductEntName() {
			return this.productEntName;
		}
		public void setProductEntName(String productEntName) {
			this.productEntName = productEntName;
		}
		public String getValidEndDate() {
			return this.validEndDate;
		}
		public void setValidEndDate(String validEndDate) {
			this.validEndDate = validEndDate;
		}

}

	/**
 * 最外层对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BillUpOutDetailDto extends TaobaoObject {

	private static final long serialVersionUID = 8524729338944697271L;

	/**
		 * 单据编码
		 */
		@ApiField("bill_code")
		private String billCode;
		/**
		 * 单据类型
		 */
		@ApiField("bill_type")
		private String billType;
		/**
		 * 单据类型描述
		 */
		@ApiField("bill_type_name")
		private String billTypeName;
		/**
		 * 药品信息数据
		 */
		@ApiListField("drug_infos_dto_list")
		@ApiField("drug_infos_dto")
		private List<DrugInfosDto> drugInfosDtoList;
		/**
		 * 收货企业ref_ent_id
		 */
		@ApiField("ent_recv_id")
		private String entRecvId;
		/**
		 * 收货企业名称
		 */
		@ApiField("ent_recv_name")
		private String entRecvName;
		/**
		 * 发货企业的ref_ent_id
		 */
		@ApiField("ent_send_id")
		private String entSendId;
		/**
		 * 发货企业名称
		 */
		@ApiField("ent_send_name")
		private String entSendName;
		/**
		 * 单据日期
		 */
		@ApiField("store_out_date")
		private String storeOutDate;
		/**
		 * 最后更新时间
		 */
		@ApiField("update_date")
		private String updateDate;
	

	public String getBillCode() {
			return this.billCode;
		}
		public void setBillCode(String billCode) {
			this.billCode = billCode;
		}
		public String getBillType() {
			return this.billType;
		}
		public void setBillType(String billType) {
			this.billType = billType;
		}
		public String getBillTypeName() {
			return this.billTypeName;
		}
		public void setBillTypeName(String billTypeName) {
			this.billTypeName = billTypeName;
		}
		public List<DrugInfosDto> getDrugInfosDtoList() {
			return this.drugInfosDtoList;
		}
		public void setDrugInfosDtoList(List<DrugInfosDto> drugInfosDtoList) {
			this.drugInfosDtoList = drugInfosDtoList;
		}
		public String getEntRecvId() {
			return this.entRecvId;
		}
		public void setEntRecvId(String entRecvId) {
			this.entRecvId = entRecvId;
		}
		public String getEntRecvName() {
			return this.entRecvName;
		}
		public void setEntRecvName(String entRecvName) {
			this.entRecvName = entRecvName;
		}
		public String getEntSendId() {
			return this.entSendId;
		}
		public void setEntSendId(String entSendId) {
			this.entSendId = entSendId;
		}
		public String getEntSendName() {
			return this.entSendName;
		}
		public void setEntSendName(String entSendName) {
			this.entSendName = entSendName;
		}
		public String getStoreOutDate() {
			return this.storeOutDate;
		}
		public void setStoreOutDate(String storeOutDate) {
			this.storeOutDate = storeOutDate;
		}
		public String getUpdateDate() {
			return this.updateDate;
		}
		public void setUpdateDate(String updateDate) {
			this.updateDate = updateDate;
		}

}

	/**
 * 监控宝推送网站监控信息，返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ResultModel extends TaobaoObject {

	private static final long serialVersionUID = 3548574166113877558L;

	/**
		 * 最外层对象
		 */
		@ApiField("model")
		private BillUpOutDetailDto model;
		/**
		 * 提示信息编码
		 */
		@ApiField("msg_code")
		private String msgCode;
		/**
		 * 提示信息内容
		 */
		@ApiField("msg_info")
		private String msgInfo;
		/**
		 * 成功失败标记
		 */
		@ApiField("success")
		private Boolean success;
	

	public BillUpOutDetailDto getModel() {
			return this.model;
		}
		public void setModel(BillUpOutDetailDto model) {
			this.model = model;
		}
		public String getMsgCode() {
			return this.msgCode;
		}
		public void setMsgCode(String msgCode) {
			this.msgCode = msgCode;
		}
		public String getMsgInfo() {
			return this.msgInfo;
		}
		public void setMsgInfo(String msgInfo) {
			this.msgInfo = msgInfo;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}



}
