package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.query.listparts response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaAlihealthDrugtraceTopYljgQueryListpartsResponse extends TaobaoResponse {

	private static final long serialVersionUID = 2422915619234479212L;

	/** 
	 * 监控宝推送网站监控信息，返回结果
	 */
	@ApiField("result")
	private ResultModel result;


	public void setResult(ResultModel result) {
		this.result = result;
	}
	public ResultModel getResult( ) {
		return this.result;
	}
	
	/**
 * 返回列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PEntParDto extends TaobaoObject {

	private static final long serialVersionUID = 8596372616118792738L;

	/**
		 * 所在市
		 */
		@ApiField("area_name")
		private String areaName;
		/**
		 * 所在县
		 */
		@ApiField("city_name")
		private String cityName;
		/**
		 * 创建日期
		 */
		@ApiField("crt_date")
		private String crtDate;
		/**
		 * 创建IC码
		 */
		@ApiField("crt_ic_code")
		private String crtIcCode;
		/**
		 * 创建IC名称
		 */
		@ApiField("crt_ic_name")
		private String crtIcName;
		/**
		 * 企业id（查询企业自已的）
		 */
		@ApiField("ent_id")
		private String entId;
		/**
		 * 往来单位企业所在省编码
		 */
		@ApiField("ent_prov_code")
		private String entProvCode;
		/**
		 * 是不是入网企业[1代表入网企业，其它为非入网]
		 */
		@ApiField("is_network")
		private String isNetwork;
		/**
		 * 最近修改日期
		 */
		@ApiField("last_mod_date")
		private String lastModDate;
		/**
		 * 修改IC码
		 */
		@ApiField("mod_ic_code")
		private String modIcCode;
		/**
		 * 修改IC名称
		 */
		@ApiField("mod_ic_name")
		private String modIcName;
		/**
		 * 合作ID
		 */
		@ApiField("p_ent_par_id")
		private String pEntParId;
		/**
		 * 拼音缩写
		 */
		@ApiField("partner_capital_name")
		private String partnerCapitalName;
		/**
		 * 往来单位企业id【单据上传时的收发货企业填的就这个字段】
		 */
		@ApiField("partner_ent_id")
		private String partnerEntId;
		/**
		 * 往来单位自定义编码
		 */
		@ApiField("partner_id")
		private String partnerId;
		/**
		 * 级别
		 */
		@ApiField("partner_level")
		private String partnerLevel;
		/**
		 * 往来单位名称
		 */
		@ApiField("partner_name")
		private String partnerName;
		/**
		 * 类型
		 */
		@ApiField("partner_type")
		private String partnerType;
		/**
		 * 所在省
		 */
		@ApiField("prov_name")
		private String provName;
		/**
		 * 查询企业的唯一标识（查询企业自已的）
		 */
		@ApiField("ref_ent_id")
		private String refEntId;
		/**
		 * 状态
		 */
		@ApiField("status")
		private String status;
	

	public String getAreaName() {
			return this.areaName;
		}
		public void setAreaName(String areaName) {
			this.areaName = areaName;
		}
		public String getCityName() {
			return this.cityName;
		}
		public void setCityName(String cityName) {
			this.cityName = cityName;
		}
		public String getCrtDate() {
			return this.crtDate;
		}
		public void setCrtDate(String crtDate) {
			this.crtDate = crtDate;
		}
		public String getCrtIcCode() {
			return this.crtIcCode;
		}
		public void setCrtIcCode(String crtIcCode) {
			this.crtIcCode = crtIcCode;
		}
		public String getCrtIcName() {
			return this.crtIcName;
		}
		public void setCrtIcName(String crtIcName) {
			this.crtIcName = crtIcName;
		}
		public String getEntId() {
			return this.entId;
		}
		public void setEntId(String entId) {
			this.entId = entId;
		}
		public String getEntProvCode() {
			return this.entProvCode;
		}
		public void setEntProvCode(String entProvCode) {
			this.entProvCode = entProvCode;
		}
		public String getIsNetwork() {
			return this.isNetwork;
		}
		public void setIsNetwork(String isNetwork) {
			this.isNetwork = isNetwork;
		}
		public String getLastModDate() {
			return this.lastModDate;
		}
		public void setLastModDate(String lastModDate) {
			this.lastModDate = lastModDate;
		}
		public String getModIcCode() {
			return this.modIcCode;
		}
		public void setModIcCode(String modIcCode) {
			this.modIcCode = modIcCode;
		}
		public String getModIcName() {
			return this.modIcName;
		}
		public void setModIcName(String modIcName) {
			this.modIcName = modIcName;
		}
		public String getpEntParId() {
			return this.pEntParId;
		}
		public void setpEntParId(String pEntParId) {
			this.pEntParId = pEntParId;
		}
		public String getPartnerCapitalName() {
			return this.partnerCapitalName;
		}
		public void setPartnerCapitalName(String partnerCapitalName) {
			this.partnerCapitalName = partnerCapitalName;
		}
		public String getPartnerEntId() {
			return this.partnerEntId;
		}
		public void setPartnerEntId(String partnerEntId) {
			this.partnerEntId = partnerEntId;
		}
		public String getPartnerId() {
			return this.partnerId;
		}
		public void setPartnerId(String partnerId) {
			this.partnerId = partnerId;
		}
		public String getPartnerLevel() {
			return this.partnerLevel;
		}
		public void setPartnerLevel(String partnerLevel) {
			this.partnerLevel = partnerLevel;
		}
		public String getPartnerName() {
			return this.partnerName;
		}
		public void setPartnerName(String partnerName) {
			this.partnerName = partnerName;
		}
		public String getPartnerType() {
			return this.partnerType;
		}
		public void setPartnerType(String partnerType) {
			this.partnerType = partnerType;
		}
		public String getProvName() {
			return this.provName;
		}
		public void setProvName(String provName) {
			this.provName = provName;
		}
		public String getRefEntId() {
			return this.refEntId;
		}
		public void setRefEntId(String refEntId) {
			this.refEntId = refEntId;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}

}

	/**
 * 返回对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Page extends TaobaoObject {

	private static final long serialVersionUID = 3848753993439797896L;

	/**
		 * 返回列表
		 */
		@ApiListField("result_list")
		@ApiField("p_ent_par_dto")
		private List<PEntParDto> resultList;
		/**
		 * 总数
		 */
		@ApiField("total_num")
		private Long totalNum;
	

	public List<PEntParDto> getResultList() {
			return this.resultList;
		}
		public void setResultList(List<PEntParDto> resultList) {
			this.resultList = resultList;
		}
		public Long getTotalNum() {
			return this.totalNum;
		}
		public void setTotalNum(Long totalNum) {
			this.totalNum = totalNum;
		}

}

	/**
 * 监控宝推送网站监控信息，返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ResultModel extends TaobaoObject {

	private static final long serialVersionUID = 4251429648388273486L;

	/**
		 * 返回对象
		 */
		@ApiField("model")
		private Page model;
		/**
		 * 返回码
		 */
		@ApiField("msg_code")
		private String msgCode;
		/**
		 * 返回值
		 */
		@ApiField("msg_info")
		private String msgInfo;
		/**
		 * 是否响应成功
		 */
		@ApiField("response_success")
		private Boolean responseSuccess;
	

	public Page getModel() {
			return this.model;
		}
		public void setModel(Page model) {
			this.model = model;
		}
		public String getMsgCode() {
			return this.msgCode;
		}
		public void setMsgCode(String msgCode) {
			this.msgCode = msgCode;
		}
		public String getMsgInfo() {
			return this.msgInfo;
		}
		public void setMsgInfo(String msgInfo) {
			this.msgInfo = msgInfo;
		}
		public Boolean getResponseSuccess() {
			return this.responseSuccess;
		}
		public void setResponseSuccess(Boolean responseSuccess) {
			this.responseSuccess = responseSuccess;
		}

}



}
