package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.query.relation response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaAlihealthDrugtraceTopYljgQueryRelationResponse extends TaobaoResponse {

	private static final long serialVersionUID = 4542926125334594446L;

	/** 
	 * 接口返回model
	 */
	@ApiField("result")
	private ResultModel result;


	public void setResult(ResultModel result) {
		this.result = result;
	}
	public ResultModel getResult( ) {
		return this.result;
	}
	
	/**
 * 激活信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CodeActiveInfoDto extends TaobaoObject {

	private static final long serialVersionUID = 2246253783694452618L;

	/**
		 * 总激活数量
		 */
		@ApiField("active_count")
		private Long activeCount;
		/**
		 * 激活时间
		 */
		@ApiField("active_date")
		private Date activeDate;
		/**
		 * 单据id
		 */
		@ApiField("bill_in_id")
		private String billInId;
		/**
		 * 激活信息id
		 */
		@ApiField("code_active_info_id")
		private String codeActiveInfoId;
		/**
		 * 激活时间
		 */
		@ApiField("crt_date")
		private Date crtDate;
		/**
		 * 关联关系文件上传日期
		 */
		@ApiField("crt_date_string")
		private String crtDateString;
		/**
		 * 旧企业ID
		 */
		@ApiField("ent_id")
		private String entId;
		/**
		 * 操作人编码
		 */
		@ApiField("oper_ic_code")
		private String operIcCode;
		/**
		 * 操作人姓名
		 */
		@ApiField("oper_ic_name")
		private String operIcName;
		/**
		 * 最大包装数量
		 */
		@ApiField("other_num")
		private Long otherNum;
		/**
		 * 处理数量
		 */
		@ApiField("process_count")
		private String processCount;
		/**
		 * 处理日期
		 */
		@ApiField("process_date")
		private Date processDate;
		/**
		 * 处理结束时间
		 */
		@ApiField("process_end_date")
		private Date processEndDate;
		/**
		 * 处理标志
		 */
		@ApiField("process_flag")
		private String processFlag;
		/**
		 * 生产编号
		 */
		@ApiField("prod_code")
		private String prodCode;
		/**
		 * 企业ID
		 */
		@ApiField("ref_ent_id")
		private String refEntId;
		/**
		 * 关联关系类型
		 */
		@ApiField("relation_type")
		private String relationType;
		/**
		 * 小码数量
		 */
		@ApiField("small_num")
		private Long smallNum;
		/**
		 * 状态
		 */
		@ApiField("status")
		private String status;
		/**
		 * 上传文件名
		 */
		@ApiField("upload_file_name")
		private String uploadFileName;
		/**
		 * 上传文件路径
		 */
		@ApiField("upload_file_path")
		private String uploadFilePath;
		/**
		 * 上传标识
		 */
		@ApiField("upload_flag")
		private String uploadFlag;
		/**
		 * 紧急人
		 */
		@ApiField("user_cert")
		private String userCert;
	

	public Long getActiveCount() {
			return this.activeCount;
		}
		public void setActiveCount(Long activeCount) {
			this.activeCount = activeCount;
		}
		public Date getActiveDate() {
			return this.activeDate;
		}
		public void setActiveDate(Date activeDate) {
			this.activeDate = activeDate;
		}
		public String getBillInId() {
			return this.billInId;
		}
		public void setBillInId(String billInId) {
			this.billInId = billInId;
		}
		public String getCodeActiveInfoId() {
			return this.codeActiveInfoId;
		}
		public void setCodeActiveInfoId(String codeActiveInfoId) {
			this.codeActiveInfoId = codeActiveInfoId;
		}
		public Date getCrtDate() {
			return this.crtDate;
		}
		public void setCrtDate(Date crtDate) {
			this.crtDate = crtDate;
		}
		public String getCrtDateString() {
			return this.crtDateString;
		}
		public void setCrtDateString(String crtDateString) {
			this.crtDateString = crtDateString;
		}
		public String getEntId() {
			return this.entId;
		}
		public void setEntId(String entId) {
			this.entId = entId;
		}
		public String getOperIcCode() {
			return this.operIcCode;
		}
		public void setOperIcCode(String operIcCode) {
			this.operIcCode = operIcCode;
		}
		public String getOperIcName() {
			return this.operIcName;
		}
		public void setOperIcName(String operIcName) {
			this.operIcName = operIcName;
		}
		public Long getOtherNum() {
			return this.otherNum;
		}
		public void setOtherNum(Long otherNum) {
			this.otherNum = otherNum;
		}
		public String getProcessCount() {
			return this.processCount;
		}
		public void setProcessCount(String processCount) {
			this.processCount = processCount;
		}
		public Date getProcessDate() {
			return this.processDate;
		}
		public void setProcessDate(Date processDate) {
			this.processDate = processDate;
		}
		public Date getProcessEndDate() {
			return this.processEndDate;
		}
		public void setProcessEndDate(Date processEndDate) {
			this.processEndDate = processEndDate;
		}
		public String getProcessFlag() {
			return this.processFlag;
		}
		public void setProcessFlag(String processFlag) {
			this.processFlag = processFlag;
		}
		public String getProdCode() {
			return this.prodCode;
		}
		public void setProdCode(String prodCode) {
			this.prodCode = prodCode;
		}
		public String getRefEntId() {
			return this.refEntId;
		}
		public void setRefEntId(String refEntId) {
			this.refEntId = refEntId;
		}
		public String getRelationType() {
			return this.relationType;
		}
		public void setRelationType(String relationType) {
			this.relationType = relationType;
		}
		public Long getSmallNum() {
			return this.smallNum;
		}
		public void setSmallNum(Long smallNum) {
			this.smallNum = smallNum;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public String getUploadFileName() {
			return this.uploadFileName;
		}
		public void setUploadFileName(String uploadFileName) {
			this.uploadFileName = uploadFileName;
		}
		public String getUploadFilePath() {
			return this.uploadFilePath;
		}
		public void setUploadFilePath(String uploadFilePath) {
			this.uploadFilePath = uploadFilePath;
		}
		public String getUploadFlag() {
			return this.uploadFlag;
		}
		public void setUploadFlag(String uploadFlag) {
			this.uploadFlag = uploadFlag;
		}
		public String getUserCert() {
			return this.userCert;
		}
		public void setUserCert(String userCert) {
			this.userCert = userCert;
		}

}

	/**
 * 码关联关系
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CodeInfo extends TaobaoObject {

	private static final long serialVersionUID = 6225923449228491754L;

	/**
		 * 追溯码
		 */
		@ApiField("code")
		private String code;
		/**
		 * 包装等级
		 */
		@ApiField("code_level")
		private String codeLevel;
		/**
		 * 码等级：1代表最小码
		 */
		@ApiField("code_pack_level")
		private String codePackLevel;
		/**
		 * 父码
		 */
		@ApiField("parent_code")
		private String parentCode;
		/**
		 * 码状态（A:已激活;I:已核注;O:已核销;C:已注销;E:码不存在）
		 */
		@ApiField("status")
		private String status;
	

	public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public String getCodeLevel() {
			return this.codeLevel;
		}
		public void setCodeLevel(String codeLevel) {
			this.codeLevel = codeLevel;
		}
		public String getCodePackLevel() {
			return this.codePackLevel;
		}
		public void setCodePackLevel(String codePackLevel) {
			this.codePackLevel = codePackLevel;
		}
		public String getParentCode() {
			return this.parentCode;
		}
		public void setParentCode(String parentCode) {
			this.parentCode = parentCode;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}

}

	/**
 * 药品包装信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PkgInfoDto extends TaobaoObject {

	private static final long serialVersionUID = 4222965159564515763L;

	/**
		 * 码信息
		 */
		@ApiListField("code_list")
		@ApiField("string")
		private List<String> codeList;
	

	public List<String> getCodeList() {
			return this.codeList;
		}
		public void setCodeList(List<String> codeList) {
			this.codeList = codeList;
		}

}

	/**
 * 药品基础信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BaseInfoDto extends TaobaoObject {

	private static final long serialVersionUID = 8674195656112325667L;

	/**
		 * 批准文号
		 */
		@ApiField("approve_no")
		private String approveNo;
		/**
		 * 药品有效期至
		 */
		@ApiField("exprie_date")
		private String exprieDate;
		/**
		 * 药品信息
		 */
		@ApiField("physic_info")
		private String physicInfo;
		/**
		 * 药品通用名称
		 */
		@ApiField("physic_name")
		private String physicName;
		/**
		 * 药品类型
		 */
		@ApiField("physic_type")
		private String physicType;
		/**
		 * 药品包装比例
		 */
		@ApiField("pkg_ratio")
		private String pkgRatio;
		/**
		 * 药品包装规格
		 */
		@ApiField("pkg_spec")
		private String pkgSpec;
		/**
		 * 药品制剂规格
		 */
		@ApiField("prepn_spec")
		private String prepnSpec;
		/**
		 * 药品制剂类型
		 */
		@ApiField("prepn_type")
		private String prepnType;
		/**
		 * 药品ID
		 */
		@ApiField("prod_id")
		private String prodId;
		/**
		 * 药品生产批次号
		 */
		@ApiField("produce_batch_no")
		private String produceBatchNo;
		/**
		 * 药品生产日期
		 */
		@ApiField("produce_date")
		private String produceDate;
		/**
		 * 药品编号
		 */
		@ApiField("product_code")
		private String productCode;
		/**
		 * 企业id
		 */
		@ApiField("ref_ent_id")
		private String refEntId;
		/**
		 * 药品自类编码
		 */
		@ApiField("sub_type_no")
		private String subTypeNo;
	

	public String getApproveNo() {
			return this.approveNo;
		}
		public void setApproveNo(String approveNo) {
			this.approveNo = approveNo;
		}
		public String getExprieDate() {
			return this.exprieDate;
		}
		public void setExprieDate(String exprieDate) {
			this.exprieDate = exprieDate;
		}
		public String getPhysicInfo() {
			return this.physicInfo;
		}
		public void setPhysicInfo(String physicInfo) {
			this.physicInfo = physicInfo;
		}
		public String getPhysicName() {
			return this.physicName;
		}
		public void setPhysicName(String physicName) {
			this.physicName = physicName;
		}
		public String getPhysicType() {
			return this.physicType;
		}
		public void setPhysicType(String physicType) {
			this.physicType = physicType;
		}
		public String getPkgRatio() {
			return this.pkgRatio;
		}
		public void setPkgRatio(String pkgRatio) {
			this.pkgRatio = pkgRatio;
		}
		public String getPkgSpec() {
			return this.pkgSpec;
		}
		public void setPkgSpec(String pkgSpec) {
			this.pkgSpec = pkgSpec;
		}
		public String getPrepnSpec() {
			return this.prepnSpec;
		}
		public void setPrepnSpec(String prepnSpec) {
			this.prepnSpec = prepnSpec;
		}
		public String getPrepnType() {
			return this.prepnType;
		}
		public void setPrepnType(String prepnType) {
			this.prepnType = prepnType;
		}
		public String getProdId() {
			return this.prodId;
		}
		public void setProdId(String prodId) {
			this.prodId = prodId;
		}
		public String getProduceBatchNo() {
			return this.produceBatchNo;
		}
		public void setProduceBatchNo(String produceBatchNo) {
			this.produceBatchNo = produceBatchNo;
		}
		public String getProduceDate() {
			return this.produceDate;
		}
		public void setProduceDate(String produceDate) {
			this.produceDate = produceDate;
		}
		public String getProductCode() {
			return this.productCode;
		}
		public void setProductCode(String productCode) {
			this.productCode = productCode;
		}
		public String getRefEntId() {
			return this.refEntId;
		}
		public void setRefEntId(String refEntId) {
			this.refEntId = refEntId;
		}
		public String getSubTypeNo() {
			return this.subTypeNo;
		}
		public void setSubTypeNo(String subTypeNo) {
			this.subTypeNo = subTypeNo;
		}

}

	/**
 * 药品基础信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BaseInfosDto extends TaobaoObject {

	private static final long serialVersionUID = 6524356141944171594L;

	/**
		 * 药品基础信息
		 */
		@ApiListField("base_info_list")
		@ApiField("base_info_dto")
		private List<BaseInfoDto> baseInfoList;
	

	public List<BaseInfoDto> getBaseInfoList() {
			return this.baseInfoList;
		}
		public void setBaseInfoList(List<BaseInfoDto> baseInfoList) {
			this.baseInfoList = baseInfoList;
		}

}

	/**
 * 生产信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ProduceInfoDto extends TaobaoObject {

	private static final long serialVersionUID = 6876576123569225948L;

	/**
		 * 批次号
		 */
		@ApiField("batch_no")
		private String batchNo;
		/**
		 * 码
		 */
		@ApiField("code")
		private String code;
		/**
		 * 有效期
		 */
		@ApiField("expire_date")
		private String expireDate;
		/**
		 * 最小包装数量
		 */
		@ApiField("pkg_amount")
		private String pkgAmount;
		/**
		 * 生产日期
		 */
		@ApiField("produce_date")
		private Date produceDate;
	

	public String getBatchNo() {
			return this.batchNo;
		}
		public void setBatchNo(String batchNo) {
			this.batchNo = batchNo;
		}
		public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public String getPkgAmount() {
			return this.pkgAmount;
		}
		public void setPkgAmount(String pkgAmount) {
			this.pkgAmount = pkgAmount;
		}
		public Date getProduceDate() {
			return this.produceDate;
		}
		public void setProduceDate(Date produceDate) {
			this.produceDate = produceDate;
		}

}

	/**
 * model
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CodeRelationDto extends TaobaoObject {

	private static final long serialVersionUID = 3615215925682165833L;

	/**
		 * 药品基础信息
		 */
		@ApiField("base_infos_dto")
		private BaseInfosDto baseInfosDto;
		/**
		 * 激活信息
		 */
		@ApiField("code_active_info_dto")
		private CodeActiveInfoDto codeActiveInfoDto;
		/**
		 * 码关联关系
		 */
		@ApiListField("code_relation_list")
		@ApiField("code_info")
		private List<CodeInfo> codeRelationList;
		/**
		 * 是否是最小包装
		 */
		@ApiField("is_smallest")
		private String isSmallest;
		/**
		 * 药品包装信息
		 */
		@ApiField("pkg_info_dto")
		private PkgInfoDto pkgInfoDto;
		/**
		 * 生产信息
		 */
		@ApiListField("produce_info_list")
		@ApiField("produce_info_dto")
		private List<ProduceInfoDto> produceInfoList;
	

	public BaseInfosDto getBaseInfosDto() {
			return this.baseInfosDto;
		}
		public void setBaseInfosDto(BaseInfosDto baseInfosDto) {
			this.baseInfosDto = baseInfosDto;
		}
		public CodeActiveInfoDto getCodeActiveInfoDto() {
			return this.codeActiveInfoDto;
		}
		public void setCodeActiveInfoDto(CodeActiveInfoDto codeActiveInfoDto) {
			this.codeActiveInfoDto = codeActiveInfoDto;
		}
		public List<CodeInfo> getCodeRelationList() {
			return this.codeRelationList;
		}
		public void setCodeRelationList(List<CodeInfo> codeRelationList) {
			this.codeRelationList = codeRelationList;
		}
		public String getIsSmallest() {
			return this.isSmallest;
		}
		public void setIsSmallest(String isSmallest) {
			this.isSmallest = isSmallest;
		}
		public PkgInfoDto getPkgInfoDto() {
			return this.pkgInfoDto;
		}
		public void setPkgInfoDto(PkgInfoDto pkgInfoDto) {
			this.pkgInfoDto = pkgInfoDto;
		}
		public List<ProduceInfoDto> getProduceInfoList() {
			return this.produceInfoList;
		}
		public void setProduceInfoList(List<ProduceInfoDto> produceInfoList) {
			this.produceInfoList = produceInfoList;
		}

}

	/**
 * 接口返回model
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ResultModel extends TaobaoObject {

	private static final long serialVersionUID = 6493715887969396814L;

	/**
		 * model
		 */
		@ApiListField("model_list")
		@ApiField("code_relation_dto")
		private List<CodeRelationDto> modelList;
		/**
		 * msgCode
		 */
		@ApiField("msg_code")
		private String msgCode;
		/**
		 * msgInfo
		 */
		@ApiField("msg_info")
		private String msgInfo;
		/**
		 * 是否成功
		 */
		@ApiField("response_success")
		private Boolean responseSuccess;
	

	public List<CodeRelationDto> getModelList() {
			return this.modelList;
		}
		public void setModelList(List<CodeRelationDto> modelList) {
			this.modelList = modelList;
		}
		public String getMsgCode() {
			return this.msgCode;
		}
		public void setMsgCode(String msgCode) {
			this.msgCode = msgCode;
		}
		public String getMsgInfo() {
			return this.msgInfo;
		}
		public void setMsgInfo(String msgInfo) {
			this.msgInfo = msgInfo;
		}
		public Boolean getResponseSuccess() {
			return this.responseSuccess;
		}
		public void setResponseSuccess(Boolean responseSuccess) {
			this.responseSuccess = responseSuccess;
		}

}



}
