/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.tmc;

import com.taobao.api.internal.tmc.Message;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerfMon {
    private static final Log LOG = LogFactory.getLog(PerfMon.class);
    private final AtomicBoolean enabled = new AtomicBoolean(false);

    public void enable() {
        this.enabled.set(true);
    }

    public void disable() {
        this.enabled.set(false);
    }

    protected void beforeSubmitMsgToQueue(Message message) {
        try {
            if (!this.enabled.get()) {
                return;
            }
            Date outgoingTime = message.getOutgoingTime();
            if (outgoingTime == null) {
                return;
            }
            long curTime = System.currentTimeMillis();
            long rt = curTime - outgoingTime.getTime();
            LOG.info((Object)String.format("%d,%d", curTime, rt));
        }
        catch (Throwable e) {
            LOG.error((Object)"beforeSubmitMsgToQueue err", e);
        }
    }
}

