package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaAlihealthDrugtraceTopYljgListupoutResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.listupout request
 * 
 * @author top auto create
 * @since 1.0, 2024.11.15
 */
public class AlibabaAlihealthDrugtraceTopYljgListupoutRequest extends BaseTaobaoRequest<AlibabaAlihealthDrugtraceTopYljgListupoutResponse> {
	
	

	/** 
	* 开始日期（不写时分秒）
	 */
	private String beginDate;

	/** 
	* 单据号
	 */
	private String billCode;

	/** 
	* 单据类型
	 */
	private String billType;

	/** 
	* 药品ID
	 */
	private String drugEntBaseInfoId;

	/** 
	* 结束日期（不写时分秒）
	 */
	private String endDate;

	/** 
	* 发货单位
	 */
	private String fromUserId;

	/** 
	* 页码
	 */
	private Long page;

	/** 
	* 页大小
	 */
	private Long pageSize;

	/** 
	* 药品类型
	 */
	private String physicType;

	/** 
	* 生产批号
	 */
	private String produceBatchNo;

	/** 
	* 企业ID
	 */
	private String refEntId;

	/** 
	* 状态
	 */
	private String status;

	public void setBeginDate(String beginDate) {
		this.beginDate = beginDate;
	}

	public String getBeginDate() {
		return this.beginDate;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillCode() {
		return this.billCode;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public String getBillType() {
		return this.billType;
	}

	public void setDrugEntBaseInfoId(String drugEntBaseInfoId) {
		this.drugEntBaseInfoId = drugEntBaseInfoId;
	}

	public String getDrugEntBaseInfoId() {
		return this.drugEntBaseInfoId;
	}

	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}

	public String getEndDate() {
		return this.endDate;
	}

	public void setFromUserId(String fromUserId) {
		this.fromUserId = fromUserId;
	}

	public String getFromUserId() {
		return this.fromUserId;
	}

	public void setPage(Long page) {
		this.page = page;
	}

	public Long getPage() {
		return this.page;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setPhysicType(String physicType) {
		this.physicType = physicType;
	}

	public String getPhysicType() {
		return this.physicType;
	}

	public void setProduceBatchNo(String produceBatchNo) {
		this.produceBatchNo = produceBatchNo;
	}

	public String getProduceBatchNo() {
		return this.produceBatchNo;
	}

	public void setRefEntId(String refEntId) {
		this.refEntId = refEntId;
	}

	public String getRefEntId() {
		return this.refEntId;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getStatus() {
		return this.status;
	}

	public String getApiMethodName() {
		return "alibaba.alihealth.drugtrace.top.yljg.listupout";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("begin_date", this.beginDate);
		txtParams.put("bill_code", this.billCode);
		txtParams.put("bill_type", this.billType);
		txtParams.put("drug_ent_base_info_id", this.drugEntBaseInfoId);
		txtParams.put("end_date", this.endDate);
		txtParams.put("from_user_id", this.fromUserId);
		txtParams.put("page", this.page);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("physic_type", this.physicType);
		txtParams.put("produce_batch_no", this.produceBatchNo);
		txtParams.put("ref_ent_id", this.refEntId);
		txtParams.put("status", this.status);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAlihealthDrugtraceTopYljgListupoutResponse> getResponseClass() {
		return AlibabaAlihealthDrugtraceTopYljgListupoutResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(beginDate, "beginDate");
		RequestCheckUtils.checkNotEmpty(endDate, "endDate");
		RequestCheckUtils.checkNotEmpty(page, "page");
		RequestCheckUtils.checkNotEmpty(pageSize, "pageSize");
		RequestCheckUtils.checkNotEmpty(refEntId, "refEntId");
	}
	

}