package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaAlihealthDrugtraceTopYljgQueryBillstatusResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.query.billstatus request
 * 
 * @author top auto create
 * @since 1.0, 2024.11.15
 */
public class AlibabaAlihealthDrugtraceTopYljgQueryBillstatusRequest extends BaseTaobaoRequest<AlibabaAlihealthDrugtraceTopYljgQueryBillstatusResponse> {
	
	

	/** 
	* 代理商
	 */
	private String agentRefUserId;

	/** 
	* 开始日期（没有时分秒，【单据创建时间】）
	 */
	private String beginDate;

	/** 
	* 单据号
	 */
	private String billCode;

	/** 
	* 单据类型 A：全部 AI：全部入库 AO：全部出库
	 */
	private String billType;

	/** 
	* 状态  0, 上传成功     3, 处理成功     4, 处理失败
	 */
	private String dealStatus;

	/** 
	* 药品类型
	 */
	private String drugType;

	/** 
	* 结束日期（没有时分秒，【单据创建时间】）
	 */
	private String endDate;

	/** 
	* 发货商
	 */
	private String fromUserId;

	/** 
	* 页码
	 */
	private Long page;

	/** 
	* 页大小
	 */
	private Long pageSize;

	/** 
	* 企业ID
	 */
	private String refEntId;

	/** 
	* 收货商
	 */
	private String toUserId;

	public void setAgentRefUserId(String agentRefUserId) {
		this.agentRefUserId = agentRefUserId;
	}

	public String getAgentRefUserId() {
		return this.agentRefUserId;
	}

	public void setBeginDate(String beginDate) {
		this.beginDate = beginDate;
	}

	public String getBeginDate() {
		return this.beginDate;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillCode() {
		return this.billCode;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public String getBillType() {
		return this.billType;
	}

	public void setDealStatus(String dealStatus) {
		this.dealStatus = dealStatus;
	}

	public String getDealStatus() {
		return this.dealStatus;
	}

	public void setDrugType(String drugType) {
		this.drugType = drugType;
	}

	public String getDrugType() {
		return this.drugType;
	}

	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}

	public String getEndDate() {
		return this.endDate;
	}

	public void setFromUserId(String fromUserId) {
		this.fromUserId = fromUserId;
	}

	public String getFromUserId() {
		return this.fromUserId;
	}

	public void setPage(Long page) {
		this.page = page;
	}

	public Long getPage() {
		return this.page;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setRefEntId(String refEntId) {
		this.refEntId = refEntId;
	}

	public String getRefEntId() {
		return this.refEntId;
	}

	public void setToUserId(String toUserId) {
		this.toUserId = toUserId;
	}

	public String getToUserId() {
		return this.toUserId;
	}

	public String getApiMethodName() {
		return "alibaba.alihealth.drugtrace.top.yljg.query.billstatus";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("agent_ref_user_id", this.agentRefUserId);
		txtParams.put("begin_date", this.beginDate);
		txtParams.put("bill_code", this.billCode);
		txtParams.put("bill_type", this.billType);
		txtParams.put("deal_status", this.dealStatus);
		txtParams.put("drug_type", this.drugType);
		txtParams.put("end_date", this.endDate);
		txtParams.put("from_user_id", this.fromUserId);
		txtParams.put("page", this.page);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("ref_ent_id", this.refEntId);
		txtParams.put("to_user_id", this.toUserId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAlihealthDrugtraceTopYljgQueryBillstatusResponse> getResponseClass() {
		return AlibabaAlihealthDrugtraceTopYljgQueryBillstatusResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(beginDate, "beginDate");
		RequestCheckUtils.checkNotEmpty(billType, "billType");
		RequestCheckUtils.checkNotEmpty(endDate, "endDate");
		RequestCheckUtils.checkNotEmpty(page, "page");
		RequestCheckUtils.checkNotEmpty(pageSize, "pageSize");
		RequestCheckUtils.checkNotEmpty(refEntId, "refEntId");
	}
	

}