package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaAlihealthDrugtraceTopYljgQueryGetbyrefentidResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.query.getbyrefentid request
 * 
 * @author top auto create
 * @since 1.0, 2024.11.14
 */
public class AlibabaAlihealthDrugtraceTopYljgQueryGetbyrefentidRequest extends BaseTaobaoRequest<AlibabaAlihealthDrugtraceTopYljgQueryGetbyrefentidResponse> {
	
	

	/** 
	* 准备要查询的企业唯一标识（返回该唯一标识企业的详细信息）
	 */
	private String destRefEntId;

	/** 
	* 接口调用企业的唯一标识（接口调用者）
	 */
	private String refEntId;

	public void setDestRefEntId(String destRefEntId) {
		this.destRefEntId = destRefEntId;
	}

	public String getDestRefEntId() {
		return this.destRefEntId;
	}

	public void setRefEntId(String refEntId) {
		this.refEntId = refEntId;
	}

	public String getRefEntId() {
		return this.refEntId;
	}

	public String getApiMethodName() {
		return "alibaba.alihealth.drugtrace.top.yljg.query.getbyrefentid";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("dest_ref_ent_id", this.destRefEntId);
		txtParams.put("ref_ent_id", this.refEntId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAlihealthDrugtraceTopYljgQueryGetbyrefentidResponse> getResponseClass() {
		return AlibabaAlihealthDrugtraceTopYljgQueryGetbyrefentidResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(destRefEntId, "destRefEntId");
		RequestCheckUtils.checkNotEmpty(refEntId, "refEntId");
	}
	

}