package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaAlihealthDrugtraceTopYljgQueryGetentinfoResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.query.getentinfo request
 * 
 * @author top auto create
 * @since 1.0, 2025.04.24
 */
public class AlibabaAlihealthDrugtraceTopYljgQueryGetentinfoRequest extends BaseTaobaoRequest<AlibabaAlihealthDrugtraceTopYljgQueryGetentinfoResponse> {
	
	

	/** 
	* 公司名称(全称)
	 */
	private String entName;

	public void setEntName(String entName) {
		this.entName = entName;
	}

	public String getEntName() {
		return this.entName;
	}

	public String getApiMethodName() {
		return "alibaba.alihealth.drugtrace.top.yljg.query.getentinfo";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("ent_name", this.entName);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAlihealthDrugtraceTopYljgQueryGetentinfoResponse> getResponseClass() {
		return AlibabaAlihealthDrugtraceTopYljgQueryGetentinfoResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(entName, "entName");
	}
	

}