package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaAlihealthDrugtraceTopYljgQueryUpbilldetailResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.query.upbilldetail request
 * 
 * @author top auto create
 * @since 1.0, 2024.11.15
 */
public class AlibabaAlihealthDrugtraceTopYljgQueryUpbilldetailRequest extends BaseTaobaoRequest<AlibabaAlihealthDrugtraceTopYljgQueryUpbilldetailResponse> {
	
	

	/** 
	* 单据号码
	 */
	private String billCode;

	/** 
	* 本企业refEntId
	 */
	private String refEntId;

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillCode() {
		return this.billCode;
	}

	public void setRefEntId(String refEntId) {
		this.refEntId = refEntId;
	}

	public String getRefEntId() {
		return this.refEntId;
	}

	public String getApiMethodName() {
		return "alibaba.alihealth.drugtrace.top.yljg.query.upbilldetail";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("bill_code", this.billCode);
		txtParams.put("ref_ent_id", this.refEntId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAlihealthDrugtraceTopYljgQueryUpbilldetailResponse> getResponseClass() {
		return AlibabaAlihealthDrugtraceTopYljgQueryUpbilldetailResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(billCode, "billCode");
		RequestCheckUtils.checkNotEmpty(refEntId, "refEntId");
	}
	

}