package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaAlihealthDrugtraceTopYljgUploadretailResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.uploadretail request
 * 
 * @author top auto create
 * @since 1.0, 2025.05.05
 */
public class AlibabaAlihealthDrugtraceTopYljgUploadretailRequest extends BaseTaobaoRequest<AlibabaAlihealthDrugtraceTopYljgUploadretailResponse> {
	
	

	/** 
	* 单据编号（唯一）
	 */
	private String billCode;

	/** 
	* 单据时间（一般为药品入出库时间）
	 */
	private Date billTime;

	/** 
	* 单据类型[323,零售出库][322,疫苗接种][116,消费者退货入库]
	 */
	private Long billType;

	/** 
	* 购买人证件编号
	 */
	private String customerId;

	/** 
	* 购买人证件类型【1身份证2护照3 军官证4 医保卡5接种卡6学生证9其它】
	 */
	private String customerIdType;

	/** 
	* 发货企业(可为空)
	 */
	private String fromUserId;

	/** 
	* 发药人
	 */
	private String medicDispenser;

	/** 
	* 处方医师
	 */
	private String medicDoctor;

	/** 
	* 互联标识 1是  0否
	 */
	private String networkBillFlag;

	/** 
	* 单据提交者(appkey编号、可为空)
	 */
	private String operIcCode;

	/** 
	* 单据提交者姓名（可为空）
	 */
	private String operIcName;

	/** 
	* 药品类型[2,特药，3,普药]【可以随便填写，单据上传后会以实际为准】
	 */
	private Long physicType;

	/** 
	* 上传单据的医疗机构在码上放心平台的ref_ent_id，可通过“通过企业名得到唯一标识”接口获取
	 */
	private String refUserId;

	/** 
	* 备注
	 */
	private String remarks;

	/** 
	* 追溯码【多个码时用逗号拼接的字符串。要求数量在3500个码以下，但一般不要传这么多，如果网络不好很容易传输一半报错】；注意：在同一张单据里，不能有重复的码；在同一张单据中不能同时上传有关联关系的大、小码；
	 */
	private String traceCodes;

	/** 
	* 代理领药人
	 */
	private String userAgent;

	/** 
	* 患者（姓名、院内患者ID均可）
	 */
	private String userName;

	/** 
	* 用药人电话
	 */
	private String userTel;

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillCode() {
		return this.billCode;
	}

	public void setBillTime(Date billTime) {
		this.billTime = billTime;
	}

	public Date getBillTime() {
		return this.billTime;
	}

	public void setBillType(Long billType) {
		this.billType = billType;
	}

	public Long getBillType() {
		return this.billType;
	}

	public void setCustomerId(String customerId) {
		this.customerId = customerId;
	}

	public String getCustomerId() {
		return this.customerId;
	}

	public void setCustomerIdType(String customerIdType) {
		this.customerIdType = customerIdType;
	}

	public String getCustomerIdType() {
		return this.customerIdType;
	}

	public void setFromUserId(String fromUserId) {
		this.fromUserId = fromUserId;
	}

	public String getFromUserId() {
		return this.fromUserId;
	}

	public void setMedicDispenser(String medicDispenser) {
		this.medicDispenser = medicDispenser;
	}

	public String getMedicDispenser() {
		return this.medicDispenser;
	}

	public void setMedicDoctor(String medicDoctor) {
		this.medicDoctor = medicDoctor;
	}

	public String getMedicDoctor() {
		return this.medicDoctor;
	}

	public void setNetworkBillFlag(String networkBillFlag) {
		this.networkBillFlag = networkBillFlag;
	}

	public String getNetworkBillFlag() {
		return this.networkBillFlag;
	}

	public void setOperIcCode(String operIcCode) {
		this.operIcCode = operIcCode;
	}

	public String getOperIcCode() {
		return this.operIcCode;
	}

	public void setOperIcName(String operIcName) {
		this.operIcName = operIcName;
	}

	public String getOperIcName() {
		return this.operIcName;
	}

	public void setPhysicType(Long physicType) {
		this.physicType = physicType;
	}

	public Long getPhysicType() {
		return this.physicType;
	}

	public void setRefUserId(String refUserId) {
		this.refUserId = refUserId;
	}

	public String getRefUserId() {
		return this.refUserId;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	public String getRemarks() {
		return this.remarks;
	}

	public void setTraceCodes(String traceCodes) {
		this.traceCodes = traceCodes;
	}

	public String getTraceCodes() {
		return this.traceCodes;
	}

	public void setUserAgent(String userAgent) {
		this.userAgent = userAgent;
	}

	public String getUserAgent() {
		return this.userAgent;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getUserName() {
		return this.userName;
	}

	public void setUserTel(String userTel) {
		this.userTel = userTel;
	}

	public String getUserTel() {
		return this.userTel;
	}

	public String getApiMethodName() {
		return "alibaba.alihealth.drugtrace.top.yljg.uploadretail";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("bill_code", this.billCode);
		txtParams.put("bill_time", this.billTime);
		txtParams.put("bill_type", this.billType);
		txtParams.put("customer_id", this.customerId);
		txtParams.put("customer_id_type", this.customerIdType);
		txtParams.put("from_user_id", this.fromUserId);
		txtParams.put("medic_dispenser", this.medicDispenser);
		txtParams.put("medic_doctor", this.medicDoctor);
		txtParams.put("network_bill_flag", this.networkBillFlag);
		txtParams.put("oper_ic_code", this.operIcCode);
		txtParams.put("oper_ic_name", this.operIcName);
		txtParams.put("physic_type", this.physicType);
		txtParams.put("ref_user_id", this.refUserId);
		txtParams.put("remarks", this.remarks);
		txtParams.put("trace_codes", this.traceCodes);
		txtParams.put("user_agent", this.userAgent);
		txtParams.put("user_name", this.userName);
		txtParams.put("user_tel", this.userTel);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAlihealthDrugtraceTopYljgUploadretailResponse> getResponseClass() {
		return AlibabaAlihealthDrugtraceTopYljgUploadretailResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(billCode, "billCode");
		RequestCheckUtils.checkNotEmpty(billTime, "billTime");
		RequestCheckUtils.checkNotEmpty(billType, "billType");
		RequestCheckUtils.checkNotEmpty(refUserId, "refUserId");
		RequestCheckUtils.checkNotEmpty(traceCodes, "traceCodes");
		RequestCheckUtils.checkMaxListSize(traceCodes, 3500, "traceCodes");
	}
	

}