package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.alihealth.drugtrace.top.yljg.query.codedetail response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaAlihealthDrugtraceTopYljgQueryCodedetailResponse extends TaobaoResponse {

	private static final long serialVersionUID = 3298583669922185822L;

	/** 
	 * 最外层结果
	 */
	@ApiField("result")
	private ResultModel result;


	public void setResult(ResultModel result) {
		this.result = result;
	}
	public ResultModel getResult( ) {
		return this.result;
	}
	
	/**
 * 码对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CodeStatusTypeDto extends TaobaoObject {

	private static final long serialVersionUID = 1654664639641737186L;

	/**
		 * 码状态（A:已激活;I:已核注;O:已核销;C:已注销;E:码不存在）
		 */
		@ApiField("code_status")
		private String codeStatus;
	

	public String getCodeStatus() {
			return this.codeStatus;
		}
		public void setCodeStatus(String codeStatus) {
			this.codeStatus = codeStatus;
		}

}

	/**
 * 企业信息对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PUserEntDto extends TaobaoObject {

	private static final long serialVersionUID = 8225612678457611779L;

	/**
		 * 企业名称
		 */
		@ApiField("ent_name")
		private String entName;
		/**
		 * 企业id
		 */
		@ApiField("ref_ent_id")
		private String refEntId;
	

	public String getEntName() {
			return this.entName;
		}
		public void setEntName(String entName) {
			this.entName = entName;
		}
		public String getRefEntId() {
			return this.refEntId;
		}
		public void setRefEntId(String refEntId) {
			this.refEntId = refEntId;
		}

}

	/**
 * 药品基本信息对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class DrugEntBaseDto extends TaobaoObject {

	private static final long serialVersionUID = 1224649919381693494L;

	/**
		 * 批准文号
		 */
		@ApiField("approval_licence_no")
		private String approvalLicenceNo;
		/**
		 * 药品id
		 */
		@ApiField("drug_ent_base_info_id")
		private String drugEntBaseInfoId;
		/**
		 * 有效期
		 */
		@ApiField("exprie")
		private String exprie;
		/**
		 * 药品名称
		 */
		@ApiField("physic_name")
		private String physicName;
		/**
		 * 药品类型描述
		 */
		@ApiField("physic_type_desc")
		private String physicTypeDesc;
		/**
		 * 包装规格
		 */
		@ApiField("pkg_spec_crit")
		private String pkgSpecCrit;
		/**
		 * 制剂规格
		 */
		@ApiField("prepn_spec")
		private String prepnSpec;
		/**
		 * 剂型描述
		 */
		@ApiField("prepn_type_desc")
		private String prepnTypeDesc;
	

	public String getApprovalLicenceNo() {
			return this.approvalLicenceNo;
		}
		public void setApprovalLicenceNo(String approvalLicenceNo) {
			this.approvalLicenceNo = approvalLicenceNo;
		}
		public String getDrugEntBaseInfoId() {
			return this.drugEntBaseInfoId;
		}
		public void setDrugEntBaseInfoId(String drugEntBaseInfoId) {
			this.drugEntBaseInfoId = drugEntBaseInfoId;
		}
		public String getExprie() {
			return this.exprie;
		}
		public void setExprie(String exprie) {
			this.exprie = exprie;
		}
		public String getPhysicName() {
			return this.physicName;
		}
		public void setPhysicName(String physicName) {
			this.physicName = physicName;
		}
		public String getPhysicTypeDesc() {
			return this.physicTypeDesc;
		}
		public void setPhysicTypeDesc(String physicTypeDesc) {
			this.physicTypeDesc = physicTypeDesc;
		}
		public String getPkgSpecCrit() {
			return this.pkgSpecCrit;
		}
		public void setPkgSpecCrit(String pkgSpecCrit) {
			this.pkgSpecCrit = pkgSpecCrit;
		}
		public String getPrepnSpec() {
			return this.prepnSpec;
		}
		public void setPrepnSpec(String prepnSpec) {
			this.prepnSpec = prepnSpec;
		}
		public String getPrepnTypeDesc() {
			return this.prepnTypeDesc;
		}
		public void setPrepnTypeDesc(String prepnTypeDesc) {
			this.prepnTypeDesc = prepnTypeDesc;
		}

}

	/**
 * 生产信息集合
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ProduceInfoDto extends TaobaoObject {

	private static final long serialVersionUID = 1196471563595321864L;

	/**
		 * 批次号
		 */
		@ApiField("batch_no")
		private String batchNo;
		/**
		 * 有效期至
		 */
		@ApiField("expire_date")
		private String expireDate;
		/**
		 * 最小包装数量
		 */
		@ApiField("pkg_amount")
		private String pkgAmount;
		/**
		 * 生产日期
		 */
		@ApiField("produce_date_str")
		private String produceDateStr;
	

	public String getBatchNo() {
			return this.batchNo;
		}
		public void setBatchNo(String batchNo) {
			this.batchNo = batchNo;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public String getPkgAmount() {
			return this.pkgAmount;
		}
		public void setPkgAmount(String pkgAmount) {
			this.pkgAmount = pkgAmount;
		}
		public String getProduceDateStr() {
			return this.produceDateStr;
		}
		public void setProduceDateStr(String produceDateStr) {
			this.produceDateStr = produceDateStr;
		}

}

	/**
 * 码生产信息对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CodeProduceInfoDto extends TaobaoObject {

	private static final long serialVersionUID = 5435251168419911383L;

	/**
		 * 生产信息集合
		 */
		@ApiListField("produce_info_list")
		@ApiField("produce_info_dto")
		private List<ProduceInfoDto> produceInfoList;
	

	public List<ProduceInfoDto> getProduceInfoList() {
			return this.produceInfoList;
		}
		public void setProduceInfoList(List<ProduceInfoDto> produceInfoList) {
			this.produceInfoList = produceInfoList;
		}

}

	/**
 * 内层大对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CodeFullInfoDto extends TaobaoObject {

	private static final long serialVersionUID = 4138777642982641156L;

	/**
		 * 追溯码
		 */
		@ApiField("code")
		private String code;
		/**
		 * 码生产信息对象
		 */
		@ApiField("code_produce_info_d_t_o")
		private CodeProduceInfoDto codeProduceInfoDTO;
		/**
		 * 码对象
		 */
		@ApiField("code_status_type_d_t_o")
		private CodeStatusTypeDto codeStatusTypeDTO;
		/**
		 * 药品基本信息对象
		 */
		@ApiField("drug_ent_base_d_t_o")
		private DrugEntBaseDto drugEntBaseDTO;
		/**
		 * 企业信息对象
		 */
		@ApiField("p_user_ent_d_t_o")
		private PUserEntDto pUserEntDTO;
		/**
		 * 码等级【1代表最小码 如：申请的包装比例是1:5:10, 对应的码等级就是3、2、1, 代表大码、中码、小码】
		 */
		@ApiField("package_level")
		private String packageLevel;
	

	public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public CodeProduceInfoDto getCodeProduceInfoDTO() {
			return this.codeProduceInfoDTO;
		}
		public void setCodeProduceInfoDTO(CodeProduceInfoDto codeProduceInfoDTO) {
			this.codeProduceInfoDTO = codeProduceInfoDTO;
		}
		public CodeStatusTypeDto getCodeStatusTypeDTO() {
			return this.codeStatusTypeDTO;
		}
		public void setCodeStatusTypeDTO(CodeStatusTypeDto codeStatusTypeDTO) {
			this.codeStatusTypeDTO = codeStatusTypeDTO;
		}
		public DrugEntBaseDto getDrugEntBaseDTO() {
			return this.drugEntBaseDTO;
		}
		public void setDrugEntBaseDTO(DrugEntBaseDto drugEntBaseDTO) {
			this.drugEntBaseDTO = drugEntBaseDTO;
		}
		public PUserEntDto getpUserEntDTO() {
			return this.pUserEntDTO;
		}
		public void setpUserEntDTO(PUserEntDto pUserEntDTO) {
			this.pUserEntDTO = pUserEntDTO;
		}
		public String getPackageLevel() {
			return this.packageLevel;
		}
		public void setPackageLevel(String packageLevel) {
			this.packageLevel = packageLevel;
		}

}

	/**
 * 最外层结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ResultModel extends TaobaoObject {

	private static final long serialVersionUID = 3495197624925436384L;

	/**
		 * 内层大对象
		 */
		@ApiListField("models")
		@ApiField("code_full_info_dto")
		private List<CodeFullInfoDto> models;
		/**
		 * 消息码
		 */
		@ApiField("msg_code")
		private String msgCode;
		/**
		 * 消息提示内容
		 */
		@ApiField("msg_info")
		private String msgInfo;
		/**
		 * 查询成功失败标记
		 */
		@ApiField("response_success")
		private Boolean responseSuccess;
	

	public List<CodeFullInfoDto> getModels() {
			return this.models;
		}
		public void setModels(List<CodeFullInfoDto> models) {
			this.models = models;
		}
		public String getMsgCode() {
			return this.msgCode;
		}
		public void setMsgCode(String msgCode) {
			this.msgCode = msgCode;
		}
		public String getMsgInfo() {
			return this.msgInfo;
		}
		public void setMsgInfo(String msgInfo) {
			this.msgInfo = msgInfo;
		}
		public Boolean getResponseSuccess() {
			return this.responseSuccess;
		}
		public void setResponseSuccess(Boolean responseSuccess) {
			this.responseSuccess = responseSuccess;
		}

}



}
